/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.recovery.internal;

import com.swirlds.common.utility.BinarySearch;
import com.swirlds.platform.recovery.internal.EventStreamLowerBound;
import com.swirlds.platform.recovery.internal.EventStreamRoundLowerBound;
import com.swirlds.platform.recovery.internal.EventStreamSingleFileIterator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.hiero.consensus.model.event.CesEvent;

public class EventStreamPathIterator
implements Iterator<Path> {
    private final Iterator<Path> iterator;
    private static final String EVENT_FILE_EXTENSION = ".evts";
    public static final long FIRST_ROUND_AVAILABLE = 1L;

    public EventStreamPathIterator(@NonNull Path eventStreamDirectory, @NonNull EventStreamLowerBound bound) throws IOException {
        Objects.requireNonNull(eventStreamDirectory, "the event stream directory must not be null");
        Objects.requireNonNull(bound, "the lower bound must not be null");
        ArrayList eventStreamFiles = new ArrayList();
        try (Stream<Path> walk = Files.walk(eventStreamDirectory, new FileVisitOption[0]);){
            walk.filter(EventStreamPathIterator::isFileAnEventStreamFile).sorted(EventStreamPathIterator::compareEventStreamPaths).forEachOrdered(eventStreamFiles::add);
        }
        if (eventStreamFiles.isEmpty()) {
            this.iterator = Collections.emptyIterator();
            return;
        }
        CesEvent firstEvent = EventStreamPathIterator.getFirstEventInEventStreamFile((Path)eventStreamFiles.get(0));
        if (bound == EventStreamLowerBound.UNBOUNDED || bound.compareTo(firstEvent) == 0) {
            this.iterator = eventStreamFiles.iterator();
        } else {
            EventStreamLowerBound usedBound;
            if (bound instanceof EventStreamRoundLowerBound) {
                EventStreamRoundLowerBound roundBound = (EventStreamRoundLowerBound)bound;
                long round = roundBound.getRound();
                long usedRound = round == 1L ? 1L : round - 1L;
                usedBound = new EventStreamRoundLowerBound(usedRound);
            } else {
                usedBound = bound;
            }
            int startingIndex = (int)BinarySearch.throwingSearch((long)0L, (long)eventStreamFiles.size(), index -> {
                Path eventStreamFile = (Path)eventStreamFiles.get(index.intValue());
                return usedBound.compareTo(EventStreamPathIterator.getFirstEventInEventStreamFile(eventStreamFile));
            });
            this.iterator = eventStreamFiles.subList(startingIndex, eventStreamFiles.size()).iterator();
        }
    }

    private static int compareEventStreamPaths(Path pathA, Path pathB) {
        return pathA.getFileName().compareTo(pathB.getFileName());
    }

    private static boolean isFileAnEventStreamFile(Path path) {
        return path.toString().endsWith(EVENT_FILE_EXTENSION);
    }

    @NonNull
    private static CesEvent getFirstEventInEventStreamFile(@NonNull Path path) throws IOException {
        try (EventStreamSingleFileIterator iterator = new EventStreamSingleFileIterator(path, true);){
            if (!iterator.hasNext()) {
                throw new IllegalStateException("Event stream file contains no events");
            }
            CesEvent cesEvent = (CesEvent)iterator.next();
            return cesEvent;
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Path next() {
        return this.iterator.next();
    }
}

