/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.media.type.MediaType;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNameEnum;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HeadersImpl;
import java.util.Collection;
import java.util.function.Consumer;

public interface WritableHeaders<B extends WritableHeaders<B>>
extends Headers {
    public static WritableHeaders<?> create() {
        return new HeadersImpl();
    }

    public static WritableHeaders<?> create(Headers headers) {
        return new HeadersImpl(headers);
    }

    public B setIfAbsent(Header var1);

    public B add(Header var1);

    default public B add(HeaderName header, String ... value) {
        return this.add(HeaderValues.create(header, value));
    }

    default public B add(HeaderName header, int value) {
        return this.add(HeaderValues.create(header, value));
    }

    default public B add(HeaderName header, long value) {
        return this.add(HeaderValues.create(header, value));
    }

    public B remove(HeaderName var1);

    public B remove(HeaderName var1, Consumer<Header> var2);

    default public B contentType(MediaType contentType) {
        return this.set(HeaderValues.create((HeaderName)HeaderNameEnum.CONTENT_TYPE, contentType.text()));
    }

    public B set(Header var1);

    default public B set(HeaderName name, String ... values) {
        return this.set(HeaderValues.create(name, true, false, values));
    }

    default public B set(HeaderName name, int value) {
        return this.set(HeaderValues.create(name, true, false, value));
    }

    default public B set(HeaderName name, long value) {
        return this.set(HeaderValues.create(name, true, false, value));
    }

    default public B set(HeaderName name, Collection<String> values) {
        return this.set(HeaderValues.create(name, values));
    }

    default public B contentLength(long length) {
        return this.set(HeaderValues.create((HeaderName)HeaderNameEnum.CONTENT_LENGTH, true, false, String.valueOf(length)));
    }

    public B clear();

    public B from(Headers var1);
}

