/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.hapi.platform.state.StateKey;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.iterators.MerkleIterator;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.disk.BackedOnDiskIterator;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.internal.merkle.VirtualLeafNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.NoSuchElementException;
import java.util.Objects;

public class OnDiskIterator<K, V>
extends BackedOnDiskIterator<K, V> {
    private final int stateId;
    private final MerkleIterator<MerkleNode> itr;
    private K next = null;

    public OnDiskIterator(@NonNull VirtualMap virtualMap, @NonNull Codec<K> keyCodec, int stateId) {
        super(virtualMap, keyCodec);
        this.stateId = stateId;
        this.itr = Objects.requireNonNull(virtualMap).treeIterator();
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.itr.hasNext()) {
            VirtualLeafNode leaf;
            Bytes k;
            int nextNextStateId;
            MerkleNode merkleNode = this.itr.next();
            if (!(merkleNode instanceof VirtualLeafNode) || this.stateId != (nextNextStateId = StateUtils.extractStateKeyValueStateId(k = (leaf = (VirtualLeafNode)merkleNode).getKey()))) continue;
            try {
                StateKey parse = (StateKey)StateKey.PROTOBUF.parse(k);
                this.next = parse.key().as();
                return true;
            }
            catch (ParseException e) {
                throw new RuntimeException("Failed to parse a key", e);
            }
        }
        return false;
    }

    @Override
    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        K k = this.next;
        this.next = null;
        return k;
    }
}

