/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.common.nativesupport;

import com.hedera.common.nativesupport.NativeLibrary;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class SingletonLoader<T> {
    private final NativeLibrary nativeLibrary;
    private final T instance;
    private final AtomicBoolean libraryLoaded = new AtomicBoolean(false);

    public SingletonLoader(String libraryName, T instance) {
        this.nativeLibrary = NativeLibrary.withName(Objects.requireNonNull(libraryName));
        this.instance = Objects.requireNonNull(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getInstance() {
        if (!this.libraryLoaded.get()) {
            SingletonLoader singletonLoader = this;
            synchronized (singletonLoader) {
                if (this.libraryLoaded.get()) {
                    return this.instance;
                }
                this.nativeLibrary.install(this.instance.getClass());
                this.libraryLoaded.set(true);
            }
        }
        return this.instance;
    }

    public String getNativeLibraryPackageName() {
        return this.nativeLibrary.packageNameOfResource();
    }
}

