/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.contract.ContractCallLocalQuery;
import com.hedera.node.app.service.contract.impl.annotations.QueryScope;
import com.hedera.node.app.service.contract.impl.exec.ActionSidecarContentTracer;
import com.hedera.node.app.service.contract.impl.exec.CallOutcome;
import com.hedera.node.app.service.contract.impl.exec.TransactionProcessor;
import com.hedera.node.app.service.contract.impl.exec.utils.OpsDurationCounter;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmContext;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmTransaction;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmTransactionResult;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmVersion;
import com.hedera.node.app.service.contract.impl.infra.HevmStaticTransactionFactory;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.inject.Inject;

@QueryScope
public class ContextQueryProcessor
implements Callable<CallOutcome> {
    private final QueryContext context;
    private final HederaEvmContext hederaEvmContext;
    private final ActionSidecarContentTracer tracer;
    private final ProxyWorldUpdater worldUpdater;
    private final HevmStaticTransactionFactory hevmStaticTransactionFactory;
    private final Map<HederaEvmVersion, TransactionProcessor> processors;

    @Inject
    public ContextQueryProcessor(@NonNull QueryContext context, @NonNull HederaEvmContext hederaEvmContext, @NonNull ActionSidecarContentTracer tracer, @NonNull ProxyWorldUpdater worldUpdater, @NonNull HevmStaticTransactionFactory hevmStaticTransactionFactory, @NonNull Map<HederaEvmVersion, TransactionProcessor> processors) {
        this.context = Objects.requireNonNull(context);
        this.tracer = Objects.requireNonNull(tracer);
        this.processors = Objects.requireNonNull(processors);
        this.worldUpdater = Objects.requireNonNull(worldUpdater);
        this.hederaEvmContext = Objects.requireNonNull(hederaEvmContext);
        this.hevmStaticTransactionFactory = Objects.requireNonNull(hevmStaticTransactionFactory);
    }

    @Override
    public CallOutcome call() {
        try {
            HederaEvmTransaction hevmTransaction = this.hevmStaticTransactionFactory.fromHapiQuery(this.context.query());
            ContractsConfig contractsConfig = (ContractsConfig)this.context.configuration().getConfigData(ContractsConfig.class);
            TransactionProcessor processor = this.processors.get((Object)HederaEvmVersion.EVM_VERSIONS.get(contractsConfig.evmVersion()));
            HederaEvmTransactionResult result = processor.processTransaction(hevmTransaction, this.worldUpdater, this.hederaEvmContext, this.tracer, this.context.configuration(), OpsDurationCounter.disabled());
            return CallOutcome.fromResultsWithoutSidecars(result.asQueryResult(this.worldUpdater), result.asEvmQueryResult(), null, null, null, result);
        }
        catch (HandleException e) {
            ContractCallLocalQuery op = this.context.query().contractCallLocalOrThrow();
            AccountID senderId = op.hasSenderId() ? op.senderIdOrThrow() : Objects.requireNonNull(this.context.payer());
            HederaEvmTransaction hevmTransaction = this.hevmStaticTransactionFactory.fromHapiQueryException(this.context.query(), e);
            HederaEvmTransactionResult result = HederaEvmTransactionResult.fromAborted(senderId, hevmTransaction.contractId(), Objects.requireNonNull(hevmTransaction.exception()).getStatus());
            return CallOutcome.fromResultsWithoutSidecars(result.asQueryResult(this.worldUpdater), result.asEvmQueryResult(), null, null, null, result);
        }
    }
}

