/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.operations;

import com.google.common.collect.ImmutableList;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomizedOpcodes;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.log.Log;
import org.hyperledger.besu.evm.log.LogTopic;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class CustomLogOperation
extends AbstractOperation {
    private final int numTopics;

    public CustomLogOperation(int numTopics, @NonNull GasCalculator gasCalculator) {
        super(switch (numTopics) {
            case 0 -> CustomizedOpcodes.LOG0.opcode();
            case 1 -> CustomizedOpcodes.LOG1.opcode();
            case 2 -> CustomizedOpcodes.LOG2.opcode();
            case 3 -> CustomizedOpcodes.LOG3.opcode();
            case 4 -> CustomizedOpcodes.LOG4.opcode();
            default -> throw new IllegalArgumentException("No EVM log operation supports " + numTopics + " topics");
        }, "LOG" + numTopics, numTopics + 2, 0, gasCalculator);
        this.numTopics = numTopics;
    }

    public Operation.OperationResult execute(@NonNull MessageFrame frame, @NonNull EVM evm) {
        long dataLocation = Words.clampedToLong((Bytes)frame.popStackItem());
        long numBytes = Words.clampedToLong((Bytes)frame.popStackItem());
        long cost = this.gasCalculator().logOperationGasCost(frame, dataLocation, numBytes, this.numTopics);
        if (frame.isStatic()) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.ILLEGAL_STATE_CHANGE);
        }
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        Bytes data = frame.readMemory(dataLocation, numBytes);
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.numTopics);
        for (int i = 0; i < this.numTopics; ++i) {
            builder.add((Object)LogTopic.create((Bytes)Bytes32.leftPad((Bytes)frame.popStackItem())));
        }
        Address loggerAddress = ConversionUtils.longZeroAddressOfRecipient(frame);
        frame.addLog(new Log(loggerAddress, data, (List)builder.build()));
        return new Operation.OperationResult(cost, null);
    }
}

