/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.PendingAirdropId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.TokenCancelAirdropTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableAirdropStore;
import com.hedera.node.app.service.token.impl.handlers.BaseTokenHandler;
import com.hedera.node.app.service.token.impl.util.AirdropHandlerHelper;
import com.hedera.node.app.service.token.impl.util.PendingAirdropUpdater;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.TokensConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenCancelAirdropHandler
extends BaseTokenHandler
implements TransactionHandler {
    private final PendingAirdropUpdater pendingAirdropUpdater;

    @Inject
    public TokenCancelAirdropHandler(@NonNull PendingAirdropUpdater pendingAirdropUpdater) {
        this.pendingAirdropUpdater = Objects.requireNonNull(pendingAirdropUpdater);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenCancelAirdropTransactionBody op = txn.tokenCancelAirdropOrThrow();
        List allPendingAirdrops = op.pendingAirdrops();
        for (PendingAirdropId airdrop : allPendingAirdrops) {
            context.requireAliasedKeyOrThrow(airdrop.senderIdOrThrow(), ResponseCodeEnum.INVALID_PENDING_AIRDROP_ID);
        }
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn, "Transaction body cannot be null");
        TokenCancelAirdropTransactionBody op = txn.tokenCancelAirdropOrThrow();
        PreCheckException.validateFalsePreCheck((boolean)op.pendingAirdrops().isEmpty(), (ResponseCodeEnum)ResponseCodeEnum.EMPTY_PENDING_AIRDROP_ID_LIST);
        HashSet<PendingAirdropId> uniquePendingAirdrops = new HashSet<PendingAirdropId>();
        for (PendingAirdropId airdrop : op.pendingAirdrops()) {
            if (!uniquePendingAirdrops.add(airdrop)) {
                throw new PreCheckException(ResponseCodeEnum.PENDING_AIRDROP_ID_REPEATED);
            }
            Validations.validateAccountID((AccountID)airdrop.receiverId(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_PENDING_AIRDROP_ID);
            Validations.validateAccountID((AccountID)airdrop.senderId(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_PENDING_AIRDROP_ID);
            if (airdrop.hasFungibleTokenType()) {
                TokenID tokenID = airdrop.fungibleTokenType();
                PreCheckException.validateTruePreCheck((tokenID != null && !tokenID.equals((Object)TokenID.DEFAULT) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
            }
            if (!airdrop.hasNonFungibleToken()) continue;
            NftID nftID = airdrop.nonFungibleTokenOrThrow();
            PreCheckException.validateTruePreCheck((nftID.tokenId() != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NFT_ID);
            PreCheckException.validateTruePreCheck((nftID.serialNumber() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER);
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenCancelAirdropTransactionBody op = txn.tokenCancelAirdropOrThrow();
        this.configValidation(context.configuration(), op);
        WritableAccountStore accountStore = (WritableAccountStore)context.storeFactory().writableStore(WritableAccountStore.class);
        WritableAirdropStore airdropStore = (WritableAirdropStore)context.storeFactory().writableStore(WritableAirdropStore.class);
        Set<PendingAirdropId> standardAirdropIds = AirdropHandlerHelper.standardizeAirdropIds(accountStore, airdropStore, op.pendingAirdrops(), EnumSet.of(AirdropHandlerHelper.IdType.SENDER));
        this.pendingAirdropUpdater.removePendingAirdrops(standardAirdropIds, airdropStore, accountStore);
    }

    private void configValidation(@NonNull Configuration configuration, @NonNull TokenCancelAirdropTransactionBody op) {
        Objects.requireNonNull(configuration);
        Objects.requireNonNull(op);
        TokensConfig tokensConfig = (TokensConfig)configuration.getConfigData(TokensConfig.class);
        HandleException.validateTrue((boolean)tokensConfig.cancelTokenAirdropEnabled(), (ResponseCodeEnum)ResponseCodeEnum.NOT_SUPPORTED);
        HandleException.validateFalse((op.pendingAirdrops().size() > tokensConfig.maxAllowedPendingAirdropsToCancel() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.PENDING_AIRDROP_ID_LIST_TOO_LONG);
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TokensConfig tokensConfig = (TokensConfig)feeContext.configuration().getConfigData(TokensConfig.class);
        HandleException.validateTrue((boolean)tokensConfig.cancelTokenAirdropEnabled(), (ResponseCodeEnum)ResponseCodeEnum.NOT_SUPPORTED);
        FeeCalculator feeCalculator = feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT);
        feeCalculator.resetUsage();
        return feeCalculator.addVerificationsPerTransaction((long)Math.max(0, feeContext.numTxnSignatures() - 1)).calculate();
    }
}

