/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.signature;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.SignaturePair;
import com.hedera.node.app.hapi.utils.MiscCryptoUtils;
import com.hedera.node.app.signature.impl.SignatureExpanderImpl;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public record ExpandedSignaturePair(@NonNull Key key, @NonNull Bytes keyBytes, @Nullable Bytes evmAlias, @NonNull SignaturePair sigPair) {
    @NonNull
    public Bytes signature() {
        return (Bytes)this.sigPair.signature().as();
    }

    @Nullable
    public static ExpandedSignaturePair maybeFrom(@NonNull Bytes compressedEcdsaPubKey, @NonNull SignaturePair sigPair) {
        Bytes ecdsaPubKey = SignatureExpanderImpl.decompressKey(compressedEcdsaPubKey);
        return ecdsaPubKey != null ? ExpandedSignaturePair.from(ecdsaPubKey, compressedEcdsaPubKey, sigPair) : null;
    }

    @NonNull
    private static ExpandedSignaturePair from(@NonNull Bytes ecdsaPubKey, @NonNull Bytes compressedEcdsaPubKey, @NonNull SignaturePair sigPair) {
        byte[] evmAddress = MiscCryptoUtils.extractEvmAddressFromDecompressedECDSAKey((byte[])ecdsaPubKey.toByteArray());
        return new ExpandedSignaturePair(Key.newBuilder().ecdsaSecp256k1(compressedEcdsaPubKey).build(), ecdsaPubKey, Bytes.wrap((byte[])evmAddress), sigPair);
    }
}

