/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.TokenBurnTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SingletonUsageProperties;
import com.hedera.node.app.hapi.fees.usage.token.TokenOpsUsageUtils;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenBurnMeta;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableNftStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.BaseTokenHandler;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.TokenSupplyChangeOpsValidator;
import com.hedera.node.app.service.token.records.TokenBurnStreamBuilder;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.TokensConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class TokenBurnHandler
extends BaseTokenHandler
implements TransactionHandler {
    @NonNull
    private final TokenSupplyChangeOpsValidator validator;

    @Inject
    public TokenBurnHandler(@NonNull TokenSupplyChangeOpsValidator validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenBurnTransactionBody op = txn.tokenBurnOrThrow();
        TokenSupplyChangeOpsValidator.verifyTokenInstanceAmounts(op.amount(), op.serialNumbers(), op.hasToken(), ResponseCodeEnum.INVALID_TOKEN_BURN_AMOUNT);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TokenBurnTransactionBody op = context.body().tokenBurnOrThrow();
        TokenID tokenId = op.tokenOrElse(TokenID.DEFAULT);
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        ReadableTokenStore.TokenMetadata tokenMetadata = tokenStore.getTokenMeta(tokenId);
        if (tokenMetadata == null) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TOKEN_ID);
        }
        if (tokenMetadata.hasSupplyKey()) {
            context.requireKey(tokenMetadata.supplyKey());
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        StoreFactory storeFactory = context.storeFactory();
        WritableAccountStore accountStore = (WritableAccountStore)storeFactory.writableStore(WritableAccountStore.class);
        WritableTokenStore tokenStore = (WritableTokenStore)storeFactory.writableStore(WritableTokenStore.class);
        WritableTokenRelationStore tokenRelStore = (WritableTokenRelationStore)storeFactory.writableStore(WritableTokenRelationStore.class);
        WritableNftStore nftStore = (WritableNftStore)storeFactory.writableStore(WritableNftStore.class);
        TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        TransactionBody txn = context.body();
        TokenBurnTransactionBody op = txn.tokenBurnOrThrow();
        TokenID tokenId = op.token();
        long fungibleBurnCount = op.amount();
        ArrayList<Long> nftSerialNums = new ArrayList<Long>(new LinkedHashSet(op.serialNumbers()));
        ValidationResult validated = this.validateSemantics(tokenId, fungibleBurnCount, nftSerialNums, tokenStore, tokenRelStore, tokensConfig);
        TokenRelation treasuryRel = validated.tokenTreasuryRel();
        Token token = validated.token();
        if (token.hasKycKey()) {
            HandleException.validateTrue((boolean)treasuryRel.kycGranted(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN);
        }
        TokenBurnStreamBuilder tokenBurnStreamBuilderRecord = (TokenBurnStreamBuilder)context.savepointStack().getBaseBuilder(TokenBurnStreamBuilder.class);
        if (token.tokenType() == TokenType.FUNGIBLE_COMMON) {
            HandleException.validateTrue((fungibleBurnCount >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_BURN_AMOUNT);
            long newTotalSupply = this.changeSupply(validated.token(), treasuryRel, -fungibleBurnCount, ResponseCodeEnum.INVALID_TOKEN_BURN_AMOUNT, accountStore, tokenStore, tokenRelStore, context.expiryValidator());
            tokenBurnStreamBuilderRecord.newTotalSupply(newTotalSupply);
        } else {
            HandleException.validateTrue((!nftSerialNums.isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_BURN_METADATA);
            for (Long nftSerial : nftSerialNums) {
                Nft nft = nftStore.get(tokenId, nftSerial);
                HandleException.validateTrue((nft != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NFT_ID);
                AccountID nftOwner = nft.ownerId();
                HandleException.validateTrue((boolean)this.treasuryOwnsNft(nftOwner), (ResponseCodeEnum)ResponseCodeEnum.TREASURY_MUST_OWN_BURNED_NFT);
            }
            long newTotalSupply = this.changeSupply(token, treasuryRel, -nftSerialNums.size(), ResponseCodeEnum.FAIL_INVALID, accountStore, tokenStore, tokenRelStore, context.expiryValidator());
            Account treasuryAcct = accountStore.get(token.treasuryAccountIdOrThrow());
            Account updatedTreasuryAcct = treasuryAcct.copyBuilder().numberOwnedNfts(treasuryAcct.numberOwnedNfts() - (long)nftSerialNums.size()).build();
            accountStore.put(updatedTreasuryAcct);
            nftSerialNums.forEach(serialNum -> nftStore.remove(tokenId, (long)serialNum));
            tokenBurnStreamBuilderRecord.newTotalSupply(newTotalSupply);
        }
        tokenBurnStreamBuilderRecord.tokenType(token.tokenType());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TransactionBody op = feeContext.body();
        TokenBurnMeta meta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenBurnUsageFrom(CommonPbjConverters.fromPbj((TransactionBody)op));
        return feeContext.feeCalculatorFactory().feeCalculator(meta.getSerialNumsCount() > 0 ? SubType.TOKEN_NON_FUNGIBLE_UNIQUE : SubType.TOKEN_FUNGIBLE_COMMON).addBytesPerTransaction((long)meta.getBpt()).addNetworkRamByteSeconds(meta.getTransferRecordDb() * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs()).calculate();
    }

    private ValidationResult validateSemantics(@NonNull TokenID tokenId, long fungibleBurnCount, @NonNull List<Long> nftSerialNums, @NonNull ReadableTokenStore tokenStore, @NonNull ReadableTokenRelationStore tokenRelStore, @NonNull TokensConfig tokensConfig) {
        HandleException.validateTrue((fungibleBurnCount >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_BURN_AMOUNT);
        this.validator.validateBurn(fungibleBurnCount, nftSerialNums, tokensConfig);
        Token token = TokenHandlerHelper.getIfUsable(tokenId, tokenStore);
        HandleException.validateTrue((token.supplyKey() != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_HAS_NO_SUPPLY_KEY);
        AccountID treasuryAcctId = token.treasuryAccountId();
        TokenRelation treasuryRel = TokenHandlerHelper.getIfUsable(treasuryAcctId, tokenId, tokenRelStore);
        return new ValidationResult(token, treasuryRel);
    }

    private boolean treasuryOwnsNft(AccountID ownerID) {
        return ownerID == null;
    }

    private record ValidationResult(@NonNull Token token, @NonNull TokenRelation tokenTreasuryRel) {
    }
}

