/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.claimairdrops;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.PendingAirdropId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.TokenClaimAirdropTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.claimairdrops.TokenClaimAirdropTranslator;
import com.hedera.node.app.service.contract.impl.exec.utils.PendingAirdropsHelper;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.TokensConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenClaimAirdropDecoder {
    private static final int TRANSFER_LIST = 0;
    private static final int SENDER = 0;
    private static final int RECEIVER = 1;
    private static final int TOKEN = 2;
    private static final int SERIAL = 3;
    private static final int HRC_SENDER = 0;
    private static final int HRC_SERIAL = 1;

    @Inject
    public TokenClaimAirdropDecoder() {
    }

    public TransactionBody decodeTokenClaimAirdrop(@NonNull HtsCallAttempt attempt) {
        Tuple call = TokenClaimAirdropTranslator.CLAIM_AIRDROPS.decodeCall(attempt.inputBytes());
        int maxPendingAirdropsToClaim = ((TokensConfig)attempt.configuration().getConfigData(TokensConfig.class)).maxAllowedPendingAirdropsToClaim();
        Tuple[] transferList = (Tuple[])call.get(0);
        HandleException.validateFalse((transferList.length > maxPendingAirdropsToClaim ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.PENDING_AIRDROP_ID_LIST_TOO_LONG);
        List<PendingAirdropId> pendingAirdrops = PendingAirdropsHelper.decodePendingAirdrops(attempt, transferList);
        return TransactionBody.newBuilder().tokenClaimAirdrop(TokenClaimAirdropTransactionBody.newBuilder().pendingAirdrops(pendingAirdrops)).build();
    }

    public TransactionBody decodeHrcClaimAirdropFt(@NonNull HtsCallAttempt attempt) {
        Tuple call = TokenClaimAirdropTranslator.HRC_CLAIM_AIRDROP_FT.decodeCall(attempt.inputBytes());
        AccountID receiverId = attempt.senderId();
        Address senderAddress = (Address)call.get(0);
        TokenID token = attempt.redirectTokenId();
        HandleException.validateTrue((token != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        AccountID senderId = attempt.addressIdConverter().convert(senderAddress);
        return TransactionBody.newBuilder().tokenClaimAirdrop(TokenClaimAirdropTransactionBody.newBuilder().pendingAirdrops(new PendingAirdropId[]{PendingAirdropsHelper.pendingFTAirdrop(senderId, receiverId, token)})).build();
    }

    public TransactionBody decodeHrcClaimAirdropNft(@NonNull HtsCallAttempt attempt) {
        Tuple call = TokenClaimAirdropTranslator.HRC_CLAIM_AIRDROP_NFT.decodeCall(attempt.inputBytes());
        AccountID receiverId = attempt.senderId();
        Address senderAddress = (Address)call.get(0);
        long serial = (Long)call.get(1);
        TokenID token = attempt.redirectTokenId();
        HandleException.validateTrue((token != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        AccountID senderId = attempt.addressIdConverter().convert(senderAddress);
        return TransactionBody.newBuilder().tokenClaimAirdrop(TokenClaimAirdropTransactionBody.newBuilder().pendingAirdrops(new PendingAirdropId[]{PendingAirdropsHelper.pendingNFTAirdrop(senderId, receiverId, token, serial)})).build();
    }
}

