/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ReadableTokenStoreImpl
implements ReadableTokenStore {
    private final ReadableKVState<TokenID, Token> tokenState;
    private final ReadableEntityCounters entityCounters;

    public ReadableTokenStoreImpl(@NonNull ReadableStates states, @NonNull ReadableEntityCounters entityCounters) {
        Objects.requireNonNull(states);
        this.entityCounters = Objects.requireNonNull(entityCounters);
        this.tokenState = states.get("TOKENS");
    }

    @Nullable
    public ReadableTokenStore.TokenMetadata getTokenMeta(@NonNull TokenID id) {
        Objects.requireNonNull(id);
        Optional<Token> token = this.getTokenLeaf(id);
        if (token.isEmpty()) {
            return null;
        }
        return this.tokenMetaFrom(token.get());
    }

    @Nullable
    public Token get(@NonNull TokenID id) {
        Objects.requireNonNull(id);
        return this.getTokenLeaf(id).orElse(null);
    }

    private ReadableTokenStore.TokenMetadata tokenMetaFrom(Token token) {
        boolean hasRoyaltyWithFallback = false;
        List customFees = token.customFees();
        if (!customFees.isEmpty()) {
            for (CustomFee customFee : customFees) {
                if (!this.isRoyaltyWithFallback(customFee)) continue;
                hasRoyaltyWithFallback = true;
                break;
            }
        }
        return new ReadableTokenStore.TokenMetadata(token.adminKeyOrElse(null), token.kycKeyOrElse(null), token.wipeKeyOrElse(null), token.freezeKeyOrElse(null), token.supplyKeyOrElse(null), token.feeScheduleKeyOrElse(null), token.pauseKeyOrElse(null), token.symbol(), hasRoyaltyWithFallback, token.treasuryAccountId(), token.decimals());
    }

    private boolean isRoyaltyWithFallback(CustomFee fee) {
        return fee.fee().kind() == CustomFee.FeeOneOfType.ROYALTY_FEE && fee.royaltyFee().hasFallbackFee();
    }

    private Optional<Token> getTokenLeaf(TokenID tokenId) {
        Token token = (Token)this.tokenState.get((Object)tokenId);
        return Optional.ofNullable(token);
    }

    public long sizeOfState() {
        return this.entityCounters.getCounterFor(EntityType.TOKEN);
    }

    public void warm(@NonNull TokenID tokenId) {
        this.tokenState.warm((Object)tokenId);
    }
}

