/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state.logging;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.workflows.prehandle.PreHandleResult;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.hashgraph.Round;

public final class TransactionStateLogger {
    private static final Logger logger = LogManager.getLogger(TransactionStateLogger.class);

    public static void logStartRound(Round round) {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting round {} of {} events at {}", (Object)round.getRoundNum(), (Object)round.getEventCount(), (Object)round.getConsensusTimestamp());
        }
    }

    public static void logStartEvent(ConsensusEvent event, NodeInfo creator) {
        if (logger.isDebugEnabled()) {
            logger.debug("  Starting event {} at {} from node {}", (Object)event.getConsensusOrder(), (Object)event.getConsensusTimestamp(), (Object)creator.nodeId());
        }
    }

    public static void logStartUserTransaction(@NonNull Instant consensusTimestamp, @Nullable TransactionBody txBody, @NonNull AccountID payer) {
        if (logger.isDebugEnabled()) {
            logger.debug("    Starting user transaction {} at platform time {} from payer 0.0.{}", (Object)(txBody == null ? "null" : TransactionStateLogger.formatTransactionId(txBody.transactionID())), (Object)consensusTimestamp, (Object)payer.accountNum());
        }
    }

    public static void logStartUserTransactionPreHandleResultP2(@NonNull PreHandleResult preHandleResult) {
        if (logger.isDebugEnabled()) {
            AccountID payer = preHandleResult.payer();
            Key payerKey = preHandleResult.payerKey();
            logger.debug("      with preHandleResult: payer 0.0.{} with key {} with status {} with response code {}", payer == null ? "null" : payer.accountNum(), (Object)(payerKey == null ? "null" : payerKey.toString()), (Object)preHandleResult.status(), (Object)preHandleResult.responseCode());
        }
    }

    public static void logStartUserTransactionPreHandleResultP3(@NonNull PreHandleResult preHandleResult) {
        if (logger.isTraceEnabled()) {
            logger.trace("      with preHandleResult: txInfo {} with requiredKeys {} with verificationResults {}", (Object)preHandleResult.txInfo(), preHandleResult.requiredKeys(), preHandleResult.verificationResults());
        }
    }

    public static void logEndTransactionRecord(@NonNull TransactionID txID, @NonNull TransactionRecord transactionRecord) {
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("    Ending transaction ").append(TransactionStateLogger.formatTransactionId(txID));
            if (transactionRecord.receipt() != null) {
                sb.append("\n    responseCode: ").append(transactionRecord.receipt().status());
                sb.append("\n    ").append(transactionRecord.receipt());
                sb.append("\n    ").append(transactionRecord.transferList());
            }
            if (transactionRecord.transferList() != null) {
                sb.append("\n    ").append(transactionRecord.transferList());
            }
            if (transactionRecord.tokenTransferLists() != null && !transactionRecord.tokenTransferLists().isEmpty()) {
                sb.append("\n    ").append(transactionRecord.tokenTransferLists());
            }
            if (transactionRecord.tokenTransferLists() != null && !transactionRecord.tokenTransferLists().isEmpty()) {
                sb.append("\n    ").append(transactionRecord.tokenTransferLists());
            }
            if (transactionRecord.paidStakingRewards() != null && !transactionRecord.paidStakingRewards().isEmpty()) {
                sb.append("\n    ").append(transactionRecord.paidStakingRewards());
            }
            if (transactionRecord.assessedCustomFees() != null && !transactionRecord.assessedCustomFees().isEmpty()) {
                sb.append("\n    ").append(transactionRecord.assessedCustomFees());
            }
            sb.append("\n    transactionFee: ").append(transactionRecord.transactionFee()).append(" transactionHash: ").append((Object)(transactionRecord.transactionHash() == null ? "null" : transactionRecord.transactionHash()));
            sb.append("\n    scheduleRef: ").append((Object)(transactionRecord.scheduleRef() == null ? "null" : transactionRecord.scheduleRef())).append(" parentConsensusTimestamp: ").append((Object)(transactionRecord.parentConsensusTimestamp() == null ? "null" : transactionRecord.parentConsensusTimestamp()));
            sb.append("\n    alias: ").append((Object)(transactionRecord.alias() == null ? "null" : transactionRecord.alias())).append(" ethereumHash: ").append((Object)(transactionRecord.ethereumHash() == null ? "null" : transactionRecord.ethereumHash()));
            sb.append("\n    evmAddress: ").append((Object)(transactionRecord.evmAddress() == null ? "null" : transactionRecord.evmAddress())).append(" entropy: ").append((Object)(transactionRecord.entropy() == null ? "null" : transactionRecord.entropy()));
            logger.debug((CharSequence)sb);
        }
    }

    private static <K> String formatKey(@Nullable K key) {
        if (key == null) {
            return "null";
        }
        if (key instanceof AccountID) {
            AccountID accountID = (AccountID)key;
            return accountID.shardNum() + "." + accountID.realmNum() + "." + accountID.accountNum();
        }
        if (key instanceof FileID) {
            FileID fileID = (FileID)key;
            return fileID.shardNum() + "." + fileID.realmNum() + "." + fileID.fileNum();
        }
        if (key instanceof TokenID) {
            TokenID tokenID = (TokenID)key;
            return tokenID.shardNum() + "." + tokenID.realmNum() + "." + tokenID.tokenNum();
        }
        if (key instanceof TopicID) {
            TopicID topicID = (TopicID)key;
            return topicID.shardNum() + "." + topicID.realmNum() + "." + topicID.topicNum();
        }
        if (key instanceof ScheduleID) {
            ScheduleID scheduleID = (ScheduleID)key;
            return scheduleID.shardNum() + "." + scheduleID.realmNum() + "." + scheduleID.scheduleNum();
        }
        return key.toString();
    }

    private static String formatTransactionId(@Nullable TransactionID transactionID) {
        if (transactionID == null || transactionID.transactionValidStart() == null) {
            return "null";
        }
        return "TransactionID[transactionValidStart=" + String.valueOf(Instant.ofEpochSecond(transactionID.transactionValidStart().seconds(), transactionID.transactionValidStart().nanos())) + ", accountID=" + TransactionStateLogger.formatKey(transactionID.accountID()) + ", scheduled=" + transactionID.scheduled() + ", nonce=" + transactionID.nonce() + "]";
    }
}

