/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.types;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class TriggeredValuesParser {
    private TriggeredValuesParser() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static <T extends Comparable<T>> TriggeredValues<T> parseFrom(String csv, Function<String, T> valueParser) {
        ArrayList<Integer> triggers = new ArrayList<Integer>();
        ArrayList values = new ArrayList();
        StringBuilder sb = new StringBuilder();
        boolean nextTokenIsTrigger = true;
        int n = csv.length();
        for (int i = 0; i < n; ++i) {
            char here = csv.charAt(i);
            if (here == ',') {
                TriggeredValuesParser.append(triggers, values, valueParser, sb.toString(), nextTokenIsTrigger);
                nextTokenIsTrigger = !nextTokenIsTrigger;
                sb = new StringBuilder();
                continue;
            }
            sb.append(here);
        }
        TriggeredValuesParser.append(triggers, values, valueParser, sb.toString(), nextTokenIsTrigger);
        if (triggers.size() != values.size()) {
            throw new IllegalArgumentException("Cannot use input of " + triggers.size() + "triggers and " + values.size() + " values!");
        }
        TriggeredValuesParser.assertIncreasing(triggers, "triggers");
        TriggeredValuesParser.assertIncreasing(values, "values");
        return new TriggeredValues(triggers, values);
    }

    private static <T> void append(List<Integer> triggers, List<T> values, Function<String, T> valueParser, String token, boolean nextTokenIsTrigger) {
        if (nextTokenIsTrigger) {
            triggers.add(TriggeredValuesParser.triggerFrom(token));
        } else {
            values.add(valueParser.apply(token));
        }
    }

    private static <T extends Comparable<T>> void assertIncreasing(List<T> vals, String desc) {
        int n = vals.size() - 1;
        for (int i = 0; i < n; ++i) {
            Comparable b;
            Comparable a = (Comparable)vals.get(i);
            if (a.compareTo(b = (Comparable)vals.get(i + 1)) < 0) continue;
            throw new IllegalArgumentException("Given " + desc + " are not strictly increasing!");
        }
    }

    private static Integer triggerFrom(String s) {
        Integer trigger = Integer.valueOf(TriggeredValuesParser.sansDecimals(s));
        if (trigger < 0 || trigger > 100) {
            throw new IllegalArgumentException("Cannot use trigger value " + trigger + "!");
        }
        return trigger;
    }

    public static String sansDecimals(String s) {
        int i = s.indexOf(".");
        if (-1 == i) {
            return s;
        }
        return s.substring(0, i);
    }

    public record TriggeredValues<T>(List<Integer> triggers, List<T> values) {
    }
}

