/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle;

import com.hedera.hapi.platform.state.QueueState;
import com.hedera.hapi.platform.state.StateValue;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.time.Time;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.utility.MerkleTreeSnapshotReader;
import com.swirlds.common.merkle.utility.MerkleTreeSnapshotWriter;
import com.swirlds.common.utility.Mnemonics;
import com.swirlds.config.api.Configuration;
import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.State;
import com.swirlds.state.StateChangeListener;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.MerkleRootSnapshotMetrics;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.disk.OnDiskReadableKVState;
import com.swirlds.state.merkle.disk.OnDiskReadableQueueState;
import com.swirlds.state.merkle.disk.OnDiskReadableSingletonState;
import com.swirlds.state.merkle.disk.OnDiskWritableKVState;
import com.swirlds.state.merkle.disk.OnDiskWritableQueueState;
import com.swirlds.state.merkle.disk.OnDiskWritableSingletonState;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.EmptyReadableStates;
import com.swirlds.state.spi.KVChangeListener;
import com.swirlds.state.spi.QueueChangeListener;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableQueueState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableKVStateBase;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableQueueStateBase;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableSingletonStateBase;
import com.swirlds.state.spi.WritableStates;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.merkle.VirtualMapMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.json.JSONObject;

public abstract class VirtualMapState<T extends VirtualMapState<T>>
implements State {
    static final String VM_LABEL = "state";
    private static final Logger logger = LogManager.getLogger(VirtualMapState.class);
    private Time time;
    private Metrics metrics;
    private MerkleRootSnapshotMetrics snapshotMetrics = new MerkleRootSnapshotMetrics();
    private final Map<String, Map<String, StateMetadata<?, ?>>> services = new HashMap();
    private final Map<String, ReadableStates> readableStatesMap = new ConcurrentHashMap<String, ReadableStates>();
    private final Map<String, MerkleWritableStates> writableStatesMap = new HashMap<String, MerkleWritableStates>();
    private final List<StateChangeListener> listeners = new ArrayList<StateChangeListener>();
    private Configuration configuration;
    private LongSupplier roundSupplier;
    private VirtualMap virtualMap;
    private boolean startupMode = true;

    public VirtualMapState(@NonNull Configuration configuration, @NonNull Metrics metrics) {
        MerkleDbConfig merkleDbConfig = (MerkleDbConfig)configuration.getConfigData(MerkleDbConfig.class);
        MerkleDbDataSourceBuilder dsBuilder = new MerkleDbDataSourceBuilder(configuration, merkleDbConfig.initialCapacity(), merkleDbConfig.hashesRamToDiskThreshold());
        this.virtualMap = new VirtualMap(VM_LABEL, (VirtualDataSourceBuilder)dsBuilder, configuration);
        this.virtualMap.registerMetrics(metrics);
    }

    public VirtualMapState(@NonNull VirtualMap virtualMap) {
        this.virtualMap = virtualMap;
    }

    protected VirtualMapState(@NonNull VirtualMapState<T> from) {
        this.virtualMap = from.virtualMap.copy();
        this.configuration = from.configuration;
        this.roundSupplier = from.roundSupplier;
        this.startupMode = from.startupMode;
        this.listeners.addAll(from.listeners);
        for (Map.Entry<String, Map<String, StateMetadata<?, ?>>> entry : from.services.entrySet()) {
            this.services.put(entry.getKey(), new HashMap(entry.getValue()));
        }
    }

    public void init(Time time, Configuration configuration, Metrics metrics, MerkleCryptography merkleCryptography, LongSupplier roundSupplier) {
        this.time = time;
        this.configuration = configuration;
        this.metrics = metrics;
        this.snapshotMetrics = new MerkleRootSnapshotMetrics(metrics);
        this.roundSupplier = roundSupplier;
    }

    protected abstract T copyingConstructor();

    protected abstract T newInstance(@NonNull VirtualMap var1);

    @NonNull
    public ReadableStates getReadableStates(@NonNull String serviceName) {
        return this.readableStatesMap.computeIfAbsent(serviceName, s -> {
            Map<String, StateMetadata<?, ?>> stateMetadata = this.services.get(s);
            return stateMetadata == null ? EmptyReadableStates.INSTANCE : new MerkleReadableStates(stateMetadata);
        });
    }

    @NonNull
    public WritableStates getWritableStates(@NonNull String serviceName) {
        this.virtualMap.throwIfImmutable();
        return this.writableStatesMap.computeIfAbsent(serviceName, s -> {
            Map<String, StateMetadata<?, ?>> stateMetadata = this.services.getOrDefault(s, Map.of());
            return new MerkleWritableStates(serviceName, stateMetadata);
        });
    }

    public void registerCommitListener(@NonNull StateChangeListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    public void unregisterCommitListener(@NonNull StateChangeListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.remove(listener);
    }

    @NonNull
    public T copy() {
        return this.copyingConstructor();
    }

    public void computeHash() {
        this.virtualMap.throwIfMutable("Hashing should only be done on immutable states");
        this.virtualMap.throwIfDestroyed("Hashing should not be done on destroyed states");
        this.virtualMap.getHash();
    }

    public void createSnapshot(@NonNull Path targetPath) {
        Objects.requireNonNull(this.time);
        Objects.requireNonNull(this.snapshotMetrics);
        this.virtualMap.throwIfMutable();
        this.virtualMap.throwIfDestroyed();
        long startTime = this.time.currentTimeMillis();
        MerkleTreeSnapshotWriter.createSnapshot((MerkleNode)this.virtualMap, (Path)targetPath, (long)this.roundSupplier.getAsLong());
        this.snapshotMetrics.updateWriteStateToDiskTimeMetric(this.time.currentTimeMillis() - startTime);
    }

    public T loadSnapshot(@NonNull Path targetPath) throws IOException {
        MerkleNode root = MerkleTreeSnapshotReader.readStateFileData((Configuration)this.configuration, (Path)targetPath).stateRoot();
        if (!(root instanceof VirtualMap)) {
            throw new IllegalStateException("Root should be a VirtualMap, but it is " + root.getClass().getSimpleName() + " instead");
        }
        VirtualMap readVirtualMap = (VirtualMap)root;
        VirtualMap mutableCopy = readVirtualMap.copy();
        if (this.metrics != null) {
            mutableCopy.registerMetrics(this.metrics);
        }
        readVirtualMap.release();
        readVirtualMap = mutableCopy;
        return this.newInstance(readVirtualMap);
    }

    @Deprecated
    public <T extends MerkleNode> void putServiceStateIfAbsent(@NonNull StateMetadata<?, ?> md, @NonNull Supplier<T> nodeSupplier, @NonNull Consumer<T> nodeInitializer) {
        throw new UnsupportedOperationException();
    }

    public void initializeState(@NonNull StateMetadata<?, ?> md) {
        this.virtualMap.throwIfImmutable();
        Objects.requireNonNull(md);
        StateDefinition def = md.stateDefinition();
        String serviceName = md.serviceName();
        Map stateMetadata = this.services.computeIfAbsent(serviceName, k -> new HashMap());
        stateMetadata.put(def.stateKey(), md);
        this.readableStatesMap.put(serviceName, new MerkleReadableStates(stateMetadata));
        this.writableStatesMap.put(serviceName, new MerkleWritableStates(serviceName, stateMetadata));
    }

    public void unregisterService(@NonNull String serviceName) {
        this.readableStatesMap.remove(serviceName);
        this.writableStatesMap.remove(serviceName);
        this.services.remove(serviceName);
    }

    public void removeServiceState(@NonNull String serviceName, @NonNull String stateKey) {
        MerkleWritableStates writableStates;
        this.virtualMap.throwIfImmutable();
        Objects.requireNonNull(serviceName);
        Objects.requireNonNull(stateKey);
        Map<String, StateMetadata<?, ?>> stateMetadata = this.services.get(serviceName);
        if (stateMetadata != null) {
            stateMetadata.remove(stateKey);
        }
        if ((writableStates = this.writableStatesMap.get(serviceName)) != null) {
            writableStates.remove(stateKey);
        }
    }

    public Map<String, Map<String, StateMetadata<?, ?>>> getServices() {
        return this.services;
    }

    public boolean isStartUpMode() {
        return this.startupMode;
    }

    public void disableStartupMode() {
        this.startupMode = false;
    }

    public MerkleNode getRoot() {
        return this.virtualMap;
    }

    public void setTime(Time time) {
        this.time = time;
    }

    @Nullable
    public Hash getHash() {
        return this.virtualMap.getHash();
    }

    public void setHash(Hash hash) {
        throw new UnsupportedOperationException("VirtualMap is self hashing");
    }

    public boolean isMutable() {
        return this.virtualMap.isMutable();
    }

    public boolean isImmutable() {
        return this.virtualMap.isImmutable();
    }

    public boolean isDestroyed() {
        return this.virtualMap.isDestroyed();
    }

    public boolean release() {
        return this.virtualMap.release();
    }

    public void close() {
        logger.info("Closing VirtualMapState");
        try {
            this.virtualMap.getDataSource().close();
        }
        catch (IOException e) {
            logger.warn("Unable to close data source for the Virtual Map", (Throwable)e);
        }
    }

    public void commitSingletons() {
        this.services.forEach((serviceKey, serviceStates) -> serviceStates.entrySet().stream().filter(stateMetadata -> ((StateMetadata)stateMetadata.getValue()).stateDefinition().singleton()).forEach(service -> {
            WritableStates writableStates = this.getWritableStates((String)serviceKey);
            WritableSingletonStateBase writableSingleton = (WritableSingletonStateBase)writableStates.getSingleton((String)service.getKey());
            writableSingleton.commit();
        }));
    }

    public boolean isHashed() {
        return this.virtualMap.isHashed();
    }

    public String getInfoJson() {
        JSONObject rootJson = new JSONObject();
        RecordAccessor recordAccessor = this.virtualMap.getRecords();
        VirtualMapMetadata virtualMapMetadata = this.virtualMap.getMetadata();
        JSONObject virtualMapMetadataJson = new JSONObject();
        virtualMapMetadataJson.put("firstLeafPath", virtualMapMetadata.getFirstLeafPath());
        virtualMapMetadataJson.put("lastLeafPath", virtualMapMetadata.getLastLeafPath());
        rootJson.put("VirtualMapMetadata", (Object)virtualMapMetadataJson);
        JSONObject singletons = new JSONObject();
        JSONObject queues = new JSONObject();
        this.services.forEach((key, value) -> value.forEach((s, stateMetadata) -> {
            Bytes keyBytes;
            VirtualLeafBytes leafBytes;
            String serviceName = stateMetadata.serviceName();
            StateDefinition stateDefinition = stateMetadata.stateDefinition();
            String stateKey = stateDefinition.stateKey();
            if (stateDefinition.singleton()) {
                Bytes keyBytes2 = StateUtils.getStateKeyForSingleton(serviceName, stateKey);
                VirtualLeafBytes leafBytes2 = recordAccessor.findLeafRecord(keyBytes2);
                if (leafBytes2 != null) {
                    Hash hash = recordAccessor.findHash(leafBytes2.path());
                    JSONObject singletonJson = new JSONObject();
                    singletonJson.put("mnemonic", (Object)Mnemonics.generateMnemonic((Hash)hash));
                    singletonJson.put("path", leafBytes2.path());
                    singletons.put(StateUtils.computeLabel(serviceName, stateKey), (Object)singletonJson);
                }
            } else if (stateDefinition.queue() && (leafBytes = recordAccessor.findLeafRecord(keyBytes = StateUtils.getStateKeyForSingleton(serviceName, stateKey))) != null) {
                try {
                    StateValue stateValue = (StateValue)StateValue.PROTOBUF.parse(leafBytes.valueBytes());
                    QueueState queueState = stateValue.queueState();
                    JSONObject queueJson = new JSONObject();
                    queueJson.put("head", queueState.head());
                    queueJson.put("tail", queueState.tail());
                    queueJson.put("path", leafBytes.path());
                    queues.put(StateUtils.computeLabel(serviceName, stateKey), (Object)queueJson);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        }));
        rootJson.put("Singletons", (Object)singletons);
        rootJson.put("Queues (Queue States)", (Object)queues);
        return rootJson.toString();
    }

    public final class MerkleReadableStates
    extends MerkleStates {
        MerkleReadableStates(Map<String, StateMetadata<?, ?>> stateMetadata) {
            super(VirtualMapState.this, stateMetadata);
        }

        @NonNull
        protected ReadableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md) {
            return new OnDiskReadableKVState(md.serviceName(), MerkleReadableStates.extractStateKey(md), MerkleReadableStates.extractKeyCodec(md), VirtualMapState.this.virtualMap);
        }

        @NonNull
        protected ReadableSingletonState<?> createReadableSingletonState(@NonNull StateMetadata md) {
            return new OnDiskReadableSingletonState(md.serviceName(), MerkleReadableStates.extractStateKey(md), VirtualMapState.this.virtualMap);
        }

        @Override
        @NonNull
        protected ReadableQueueState createReadableQueueState(@NonNull StateMetadata md) {
            return new OnDiskReadableQueueState(md.serviceName(), MerkleReadableStates.extractStateKey(md), VirtualMapState.this.virtualMap);
        }
    }

    public final class MerkleWritableStates
    extends MerkleStates
    implements WritableStates,
    CommittableWritableStates {
        private final String serviceName;

        MerkleWritableStates(@NonNull String serviceName, Map<String, StateMetadata<?, ?>> stateMetadata) {
            super(VirtualMapState.this, stateMetadata);
            this.serviceName = Objects.requireNonNull(serviceName);
        }

        public void copyAndReleaseVirtualMap(@NonNull String stateKey) {
            StateMetadata md = (StateMetadata)this.stateMetadata.get(stateKey);
            VirtualMap mutableCopy = VirtualMapState.this.virtualMap.copy();
            if (VirtualMapState.this.metrics != null) {
                mutableCopy.registerMetrics(VirtualMapState.this.metrics);
            }
            VirtualMapState.this.virtualMap.release();
            VirtualMapState.this.virtualMap = mutableCopy;
            this.kvInstances.put(stateKey, this.createReadableKVState(md));
        }

        @NonNull
        public <K, V> WritableKVState<K, V> get(@NonNull String stateKey) {
            return (WritableKVState)super.get(stateKey);
        }

        @NonNull
        public <T> WritableSingletonState<T> getSingleton(@NonNull String stateKey) {
            return (WritableSingletonState)super.getSingleton(stateKey);
        }

        @NonNull
        public <E> WritableQueueState<E> getQueue(@NonNull String stateKey) {
            return (WritableQueueState)super.getQueue(stateKey);
        }

        @NonNull
        protected WritableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md) {
            OnDiskWritableKVState state = new OnDiskWritableKVState(md.serviceName(), MerkleWritableStates.extractStateKey(md), MerkleWritableStates.extractKeyCodec(md), VirtualMapState.this.virtualMap);
            VirtualMapState.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.MAP)) {
                    this.registerKVListener(this.serviceName, state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        @NonNull
        protected WritableSingletonState<?> createReadableSingletonState(@NonNull StateMetadata md) {
            OnDiskWritableSingletonState state = new OnDiskWritableSingletonState(md.serviceName(), MerkleWritableStates.extractStateKey(md), VirtualMapState.this.virtualMap);
            VirtualMapState.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.SINGLETON)) {
                    this.registerSingletonListener(this.serviceName, state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        @NonNull
        protected WritableQueueState<?> createReadableQueueState(@NonNull StateMetadata md) {
            OnDiskWritableQueueState state = new OnDiskWritableQueueState(md.serviceName(), MerkleWritableStates.extractStateKey(md), VirtualMapState.this.virtualMap);
            VirtualMapState.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.QUEUE)) {
                    this.registerQueueListener(this.serviceName, state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        public void commit() {
            for (ReadableKVState kv : this.kvInstances.values()) {
                ((WritableKVStateBase)kv).commit();
            }
            if (VirtualMapState.this.startupMode) {
                for (ReadableSingletonState s : this.singletonInstances.values()) {
                    ((WritableSingletonStateBase)s).commit();
                }
            }
            for (ReadableQueueState q : this.queueInstances.values()) {
                ((WritableQueueStateBase)q).commit();
            }
            VirtualMapState.this.readableStatesMap.remove(this.serviceName);
        }

        public void remove(String stateKey) {
            if (!Map.of().equals(this.stateMetadata)) {
                this.stateMetadata.remove(stateKey);
            }
            this.kvInstances.remove(stateKey);
            this.singletonInstances.remove(stateKey);
            this.queueInstances.remove(stateKey);
        }

        private <V> void registerSingletonListener(@NonNull String serviceName, @NonNull WritableSingletonStateBase<V> singletonState, @NonNull StateChangeListener listener) {
            int stateId = listener.stateIdFor(serviceName, singletonState.getStateKey());
            singletonState.registerListener(value -> listener.singletonUpdateChange(stateId, value));
        }

        private <V> void registerQueueListener(@NonNull String serviceName, @NonNull WritableQueueStateBase<V> queueState, final @NonNull StateChangeListener listener) {
            final int stateId = listener.stateIdFor(serviceName, queueState.getStateKey());
            queueState.registerListener(new QueueChangeListener<V>(this){

                public void queuePushChange(@NonNull V value) {
                    listener.queuePushChange(stateId, value);
                }

                public void queuePopChange() {
                    listener.queuePopChange(stateId);
                }
            });
        }

        private <K, V> void registerKVListener(@NonNull String serviceName, WritableKVStateBase<K, V> state, final StateChangeListener listener) {
            final int stateId = listener.stateIdFor(serviceName, state.getStateKey());
            state.registerListener(new KVChangeListener<K, V>(this){

                public void mapUpdateChange(@NonNull K key, @NonNull V value) {
                    listener.mapUpdateChange(stateId, key, value);
                }

                public void mapDeleteChange(@NonNull K key) {
                    listener.mapDeleteChange(stateId, key);
                }
            });
        }
    }

    private abstract class MerkleStates
    implements ReadableStates {
        protected final Map<String, StateMetadata<?, ?>> stateMetadata;
        protected final Map<String, ReadableKVState<?, ?>> kvInstances;
        protected final Map<String, ReadableSingletonState<?>> singletonInstances;
        protected final Map<String, ReadableQueueState<?>> queueInstances;
        private final Set<String> stateKeys;

        MerkleStates(@NonNull VirtualMapState virtualMapState, Map<String, StateMetadata<?, ?>> stateMetadata) {
            this.stateMetadata = Objects.requireNonNull(stateMetadata);
            this.stateKeys = Collections.unmodifiableSet(stateMetadata.keySet());
            this.kvInstances = new HashMap();
            this.singletonInstances = new HashMap();
            this.queueInstances = new HashMap();
        }

        @NonNull
        public <K, V> ReadableKVState<K, V> get(@NonNull String stateKey) {
            ReadableKVState<?, ?> instance = this.kvInstances.get(stateKey);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateKey);
            if (md == null || md.stateDefinition().singleton()) {
                throw new IllegalArgumentException("Unknown k/v state key '" + stateKey + ";");
            }
            ReadableKVState ret = this.createReadableKVState(md);
            this.kvInstances.put(stateKey, ret);
            return ret;
        }

        @NonNull
        public <T> ReadableSingletonState<T> getSingleton(@NonNull String stateKey) {
            ReadableSingletonState<?> instance = this.singletonInstances.get(stateKey);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateKey);
            if (md == null || !md.stateDefinition().singleton()) {
                throw new IllegalArgumentException("Unknown singleton state key '" + stateKey + "'");
            }
            ReadableSingletonState ret = this.createReadableSingletonState(md);
            this.singletonInstances.put(stateKey, ret);
            return ret;
        }

        @NonNull
        public <E> ReadableQueueState<E> getQueue(@NonNull String stateKey) {
            ReadableQueueState<?> instance = this.queueInstances.get(stateKey);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateKey);
            if (md == null || !md.stateDefinition().queue()) {
                throw new IllegalArgumentException("Unknown queue state key '" + stateKey + "'");
            }
            ReadableQueueState ret = this.createReadableQueueState(md);
            this.queueInstances.put(stateKey, ret);
            return ret;
        }

        public boolean contains(@NonNull String stateKey) {
            return this.stateMetadata.containsKey(stateKey);
        }

        @NonNull
        public Set<String> stateKeys() {
            return this.stateKeys;
        }

        @NonNull
        protected abstract ReadableKVState createReadableKVState(@NonNull StateMetadata var1);

        @NonNull
        protected abstract ReadableSingletonState createReadableSingletonState(@NonNull StateMetadata var1);

        @NonNull
        protected abstract ReadableQueueState createReadableQueueState(@NonNull StateMetadata var1);

        @NonNull
        static String extractStateKey(@NonNull StateMetadata<?, ?> md) {
            return md.stateDefinition().stateKey();
        }

        @NonNull
        static Codec<?> extractKeyCodec(@NonNull StateMetadata<?, ?> md) {
            return md.stateDefinition().keyCodec();
        }
    }
}

