/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.http.DirectHandler;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.WritableHeaders;

public class DirectTransportRequest
implements DirectHandler.TransportRequest {
    private final String version;
    private final String method;
    private final String path;
    private final ServerRequestHeaders headers;

    private DirectTransportRequest(String version, String method, String path, ServerRequestHeaders headers) {
        this.version = version;
        this.method = method;
        this.path = path;
        this.headers = headers;
    }

    public static DirectHandler.TransportRequest create(String protocolAndVersion, String method, String path) {
        return new DirectTransportRequest(protocolAndVersion, method, path, ServerRequestHeaders.create((Headers)WritableHeaders.create()));
    }

    public static DirectHandler.TransportRequest create(HttpPrologue prologue, Headers headers) {
        return new DirectTransportRequest(prologue.protocol() + "/" + prologue.protocolVersion(), prologue.method().text(), prologue.uriPath().rawPathNoParams(), ServerRequestHeaders.create((Headers)headers));
    }

    public String protocolVersion() {
        return this.version;
    }

    public String method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public ServerRequestHeaders headers() {
        return this.headers;
    }
}

