/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.TokenMintTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SingletonUsageProperties;
import com.hedera.node.app.hapi.fees.usage.token.TokenOpsUsageUtils;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenMintMeta;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableNftStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.BaseTokenHandler;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.TokenSupplyChangeOpsValidator;
import com.hedera.node.app.service.token.records.TokenMintStreamBuilder;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.TokensConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenMintHandler
extends BaseTokenHandler
implements TransactionHandler {
    private final TokenSupplyChangeOpsValidator validator;

    @Inject
    public TokenMintHandler(@NonNull TokenSupplyChangeOpsValidator validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenMintTransactionBody op = txn.tokenMintOrThrow();
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        ReadableTokenStore.TokenMetadata tokenMeta = tokenStore.getTokenMeta(op.tokenOrElse(TokenID.DEFAULT));
        if (tokenMeta == null) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TOKEN_ID);
        }
        if (tokenMeta.hasSupplyKey()) {
            context.requireKey(tokenMeta.supplyKey());
        }
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn);
        TokenMintTransactionBody op = txn.tokenMintOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasToken(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        PreCheckException.validateFalsePreCheck((!op.metadata().isEmpty() && op.amount() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        PreCheckException.validateFalsePreCheck((op.amount() < 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_MINT_AMOUNT);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        TokenMintTransactionBody op = context.body().tokenMintOrThrow();
        TokenID tokenId = context.body().tokenMintOrThrow().tokenOrThrow();
        this.validateSemantics(context);
        StoreFactory storeFactory = context.storeFactory();
        WritableTokenStore tokenStore = (WritableTokenStore)storeFactory.writableStore(WritableTokenStore.class);
        WritableTokenRelationStore tokenRelStore = (WritableTokenRelationStore)storeFactory.writableStore(WritableTokenRelationStore.class);
        WritableAccountStore accountStore = (WritableAccountStore)storeFactory.writableStore(WritableAccountStore.class);
        Token token = TokenHandlerHelper.getIfUsable(tokenId, tokenStore);
        HandleException.validateTrue((token.supplyKey() != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_HAS_NO_SUPPLY_KEY);
        TokenRelation treasuryRel = TokenHandlerHelper.getIfUsable(token.treasuryAccountId(), tokenId, tokenRelStore);
        HandleException.validateTrue((treasuryRel != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TREASURY_ACCOUNT_FOR_TOKEN);
        if (token.hasKycKey()) {
            HandleException.validateTrue((boolean)treasuryRel.kycGranted(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN);
        }
        TokenMintStreamBuilder recordBuilder = (TokenMintStreamBuilder)context.savepointStack().getBaseBuilder(TokenMintStreamBuilder.class);
        if (token.tokenType() == TokenType.FUNGIBLE_COMMON) {
            HandleException.validateTrue((op.amount() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_MINT_AMOUNT);
            long newTotalSupply = this.mintFungible(token, treasuryRel, op.amount(), accountStore, tokenStore, tokenRelStore, context.expiryValidator());
            recordBuilder.newTotalSupply(newTotalSupply);
        } else {
            TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
            long maxAllowedMints = tokensConfig.nftsMaxAllowedMints();
            WritableNftStore nftStore = (WritableNftStore)storeFactory.writableStore(WritableNftStore.class);
            List meta = op.metadata();
            HandleException.validateTrue((nftStore.sizeOfState() + (long)meta.size() <= maxAllowedMints ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_NFTS_IN_PRICE_REGIME_HAVE_BEEN_MINTED);
            List<Long> mintedSerials = this.mintNonFungible(token, treasuryRel, meta, context.consensusNow(), accountStore, tokenStore, tokenRelStore, nftStore, context.expiryValidator());
            recordBuilder.newTotalSupply(tokenStore.get(tokenId).totalSupply());
            recordBuilder.serialNumbers(mintedSerials);
        }
        recordBuilder.tokenType(token.tokenType());
    }

    private void validateSemantics(HandleContext context) {
        Objects.requireNonNull(context);
        TokenMintTransactionBody op = context.body().tokenMintOrThrow();
        TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        this.validator.validateMint(op.amount(), op.metadata(), tokensConfig);
    }

    private List<Long> mintNonFungible(Token token, @NonNull TokenRelation treasuryRel, @NonNull List<Bytes> metadata, @NonNull Instant consensusTime, @NonNull WritableAccountStore accountStore, @NonNull WritableTokenStore tokenStore, @NonNull WritableTokenRelationStore tokenRelStore, @NonNull WritableNftStore nftStore, @NonNull ExpiryValidator expiryValidator) {
        int metadataCount = metadata.size();
        HandleException.validateFalse((boolean)metadata.isEmpty(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_MINT_METADATA);
        TokenID tokenId = treasuryRel.tokenId();
        Account treasuryAccount = TokenHandlerHelper.getIfUsable(treasuryRel.accountIdOrThrow(), accountStore, expiryValidator, ResponseCodeEnum.INVALID_TREASURY_ACCOUNT_FOR_TOKEN);
        long currentSerialNumber = token.lastUsedSerialNumber();
        HandleException.validateTrue((currentSerialNumber + (long)metadataCount <= 0xFFFFFFFFL ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.SERIAL_NUMBER_LIMIT_REACHED);
        this.changeSupply(token, treasuryRel, metadataCount, ResponseCodeEnum.FAIL_INVALID, accountStore, tokenStore, tokenRelStore, expiryValidator);
        treasuryAccount = accountStore.get(treasuryRel.accountIdOrThrow());
        Token modifiedToken = tokenStore.get(token.tokenId());
        ArrayList<Long> mintedSerials = new ArrayList<Long>(metadata.size());
        for (Bytes meta : metadata) {
            Nft uniqueToken = this.buildNewlyMintedNft(consensusTime, tokenId, meta, ++currentSerialNumber);
            nftStore.putAndIncrementCount(uniqueToken);
            mintedSerials.add(currentSerialNumber);
        }
        Token.Builder copyToken = modifiedToken.copyBuilder();
        Account.Builder copyTreasury = treasuryAccount.copyBuilder();
        copyToken.totalSupply(token.totalSupply() + (long)metadataCount);
        copyToken.lastUsedSerialNumber(currentSerialNumber);
        copyTreasury.numberOwnedNfts(treasuryAccount.numberOwnedNfts() + (long)metadataCount);
        tokenStore.put(copyToken.build());
        accountStore.put(copyTreasury.build());
        return mintedSerials;
    }

    @NonNull
    private Nft buildNewlyMintedNft(@NonNull Instant consensusTime, @NonNull TokenID tokenId, @NonNull Bytes meta, long currentSerialNumber) {
        return Nft.newBuilder().nftId(NftID.newBuilder().tokenId(tokenId).serialNumber(currentSerialNumber).build()).mintTime(Timestamp.newBuilder().seconds(consensusTime.getEpochSecond()).nanos(consensusTime.getNano()).build()).metadata(meta).build();
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TokenMintTransactionBody op = feeContext.body().tokenMintOrThrow();
        SubType subType = op.amount() > 0L ? SubType.TOKEN_FUNGIBLE_COMMON : SubType.TOKEN_NON_FUNGIBLE_UNIQUE;
        FeeCalculator calculator = feeContext.feeCalculatorFactory().feeCalculator(subType);
        if (SubType.TOKEN_NON_FUNGIBLE_UNIQUE.equals((Object)subType)) {
            calculator.resetUsage();
            calculator.addVerificationsPerTransaction((long)Math.max(0, feeContext.numTxnSignatures() - 1));
        }
        TokenMintMeta meta = TokenOpsUsageUtils.TOKEN_OPS_USAGE_UTILS.tokenMintUsageFrom(CommonPbjConverters.fromPbj((TransactionBody)feeContext.body()), CommonPbjConverters.fromPbj((SubType)subType), 7776000L);
        calculator.addBytesPerTransaction((long)meta.getBpt());
        calculator.addRamByteSeconds(meta.getRbs());
        calculator.addNetworkRamByteSeconds(meta.getTransferRecordDb() * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs());
        return calculator.calculate();
    }
}

