/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.fluent;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.fluent.SimpleAccount;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;

public class SimpleWorld
implements WorldUpdater {
    SimpleWorld parent;
    Map<Address, SimpleAccount> accounts = new HashMap<Address, SimpleAccount>();

    public SimpleWorld() {
        this(null);
    }

    public SimpleWorld(SimpleWorld parent) {
        this.parent = parent;
    }

    @Override
    public WorldUpdater updater() {
        return new SimpleWorld(this);
    }

    @Override
    public Account get(Address address) {
        if (this.accounts.containsKey(address)) {
            return this.accounts.get(address);
        }
        if (this.parent != null) {
            return this.parent.get(address);
        }
        return null;
    }

    @Override
    public MutableAccount createAccount(Address address, long nonce, Wei balance) {
        if (this.getAccount(address) != null) {
            throw new IllegalStateException("Cannot create an account when one already exists");
        }
        SimpleAccount account = new SimpleAccount(address, nonce, balance);
        this.accounts.put(address, account);
        return account;
    }

    @Override
    public MutableAccount getAccount(Address address) {
        MutableAccount parentAccount;
        SimpleAccount account = this.accounts.get(address);
        if (account != null) {
            return account;
        }
        MutableAccount mutableAccount = parentAccount = this.parent == null ? null : this.parent.getAccount(address);
        if (parentAccount != null) {
            account = new SimpleAccount(parentAccount, parentAccount.getAddress(), parentAccount.getNonce(), parentAccount.getBalance(), parentAccount.getCode());
            this.accounts.put(address, account);
            return account;
        }
        return null;
    }

    @Override
    public void deleteAccount(Address address) {
        this.accounts.put(address, null);
    }

    @Override
    public Collection<? extends Account> getTouchedAccounts() {
        return this.accounts.values();
    }

    @Override
    public Collection<Address> getDeletedAccountAddresses() {
        return this.accounts.entrySet().stream().filter(e -> e.getValue() == null).map(Map.Entry::getKey).toList();
    }

    @Override
    public void revert() {
        this.accounts = new HashMap<Address, SimpleAccount>();
    }

    @Override
    public void commit() {
        this.accounts.forEach((address, account) -> {
            if (!account.updateParent()) {
                this.parent.accounts.put((Address)address, (SimpleAccount)account);
            }
        });
    }

    @Override
    public Optional<WorldUpdater> parentUpdater() {
        return Optional.ofNullable(this.parent);
    }
}

