/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class JumpiOperation
extends AbstractFixedCostOperation {
    private static final Operation.OperationResult invalidJumpResponse = new Operation.OperationResult(10L, ExceptionalHaltReason.INVALID_JUMP_DESTINATION);
    private static final Operation.OperationResult jumpiResponse = new Operation.OperationResult(10L, null, 0);
    private static final Operation.OperationResult nojumpResponse = new Operation.OperationResult(10L, null);

    public JumpiOperation(GasCalculator gasCalculator) {
        super(87, "JUMPI", 2, 0, gasCalculator, gasCalculator.getHighTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return JumpiOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        int jumpDestination;
        Bytes dest = frame.popStackItem().trimLeadingZeros();
        Bytes condition = frame.popStackItem().trimLeadingZeros();
        if (condition.size() == 0) {
            return nojumpResponse;
        }
        try {
            jumpDestination = dest.toInt();
        }
        catch (RuntimeException re) {
            return invalidJumpResponse;
        }
        Code code = frame.getCode();
        if (code.isJumpDestInvalid(jumpDestination)) {
            return invalidJumpResponse;
        }
        frame.setPC(jumpDestination);
        return jumpiResponse;
    }
}

