/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableByteBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableByteEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableByteHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableByteSingletonBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.factory.primitive.ByteBags;

@ServiceProvider(value=ImmutableByteBagFactory.class)
public class ImmutableByteBagFactoryImpl
implements ImmutableByteBagFactory {
    public static final ImmutableByteBagFactory INSTANCE = new ImmutableByteBagFactoryImpl();

    public ImmutableByteBag empty() {
        return ImmutableByteEmptyBag.INSTANCE;
    }

    public ImmutableByteBag of() {
        return this.empty();
    }

    public ImmutableByteBag with() {
        return this.empty();
    }

    public ImmutableByteBag of(byte one) {
        return this.with(one);
    }

    public ImmutableByteBag with(byte one) {
        return new ImmutableByteSingletonBag(one);
    }

    public ImmutableByteBag of(byte ... items) {
        return this.with(items);
    }

    public ImmutableByteBag with(byte ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableByteHashBag.newBagWith(items);
    }

    public ImmutableByteBag ofAll(ByteIterable items) {
        return this.withAll(items);
    }

    public ImmutableByteBag withAll(ByteIterable items) {
        if (items instanceof ImmutableByteBag) {
            return (ImmutableByteBag)items;
        }
        if (items == null) {
            return this.with();
        }
        ByteHashBag bag = new ByteHashBag();
        items.forEach(arg_0 -> ((MutableByteBag)bag).add(arg_0));
        if (bag.size() == 0) {
            return this.with();
        }
        if (bag.size() == 1) {
            return this.with(bag.toArray());
        }
        return ImmutableByteHashBag.newBagWith(bag);
    }

    public ImmutableByteBag ofAll(Iterable<Byte> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableByteBag withAll(Iterable<Byte> iterable) {
        return ByteBags.mutable.withAll(iterable).toImmutable();
    }
}

