/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.impl.api.local.ObjectPool;
import org.identityconnectors.framework.impl.api.local.operations.APIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.PoolableConnector;

public class ConnectorAPIOperationRunnerProxy
implements InvocationHandler {
    private static final Log _log = Log.getLog(ConnectorAPIOperationRunnerProxy.class);
    private final ConnectorOperationalContext _context;
    private final Constructor<? extends APIOperationRunner> _runnerImplConstructor;

    public ConnectorAPIOperationRunnerProxy(ConnectorOperationalContext context, Constructor<? extends APIOperationRunner> runnerImplConstructor) {
        this._context = context;
        this._runnerImplConstructor = runnerImplConstructor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        Object ret = null;
        Connector connector = null;
        ObjectPool<PoolableConnector> pool = this._context.getPool();
        Class<? extends Connector> connectorClazz = this._context.getConnectorClass();
        try {
            if (pool != null) {
                connector = (Connector)pool.borrowObject();
            } else {
                connector = connectorClazz.newInstance();
                connector.init(this._context.getConfiguration());
            }
            APIOperationRunner runner = this._runnerImplConstructor.newInstance(this._context, connector);
            ret = method.invoke((Object)runner, args);
        }
        catch (InvocationTargetException e) {
            Throwable root = e.getCause();
            throw root;
        }
        finally {
            if (connector != null) {
                if (pool != null) {
                    try {
                        pool.returnObject((PoolableConnector)connector);
                    }
                    catch (Exception e) {
                        _log.error((Throwable)e, null, new Object[0]);
                    }
                } else {
                    try {
                        connector.dispose();
                    }
                    catch (Exception e) {
                        _log.error((Throwable)e, null, new Object[0]);
                    }
                }
            }
        }
        return ret;
    }
}

