/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.schemas;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.token.NodeRewards;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.platform.state.SingletonType;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.service.token.impl.handlers.TokenClaimAirdropHandler;
import com.hedera.node.app.spi.workflows.SystemContext;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class V0610TokenSchema
extends Schema<SemanticVersion> {
    public static final String NODE_REWARDS_KEY = "NODE_REWARDS";
    public static final int NODE_REWARDS_STATE_ID = SingletonType.TOKENSERVICE_I_NODE_REWARDS.protoOrdinal();
    public static final String NODE_REWARDS_STATE_LABEL = StateMetadata.computeLabel((String)"TokenService", (String)"NODE_REWARDS");
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(61).patch(0).build();

    public V0610TokenSchema() {
        super((Object)VERSION, HapiUtils.SEMANTIC_VERSION_COMPARATOR);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(StateDefinition.singleton((int)NODE_REWARDS_STATE_ID, (String)NODE_REWARDS_KEY, (Codec)NodeRewards.PROTOBUF));
    }

    public void migrate(@NonNull MigrationContext ctx) {
        ReadableStates previousStates = ctx.previousStates();
        if (ctx.isGenesis() || !previousStates.contains(NODE_REWARDS_STATE_ID)) {
            WritableSingletonState nodeRewardsState = ctx.newStates().getSingleton(NODE_REWARDS_STATE_ID);
            nodeRewardsState.put((Object)NodeRewards.DEFAULT);
        }
    }

    public static void dispatchSynthNodeRewards(@NonNull SystemContext systemContext, @NonNull List<AccountID> activeNodeAccountIds, @NonNull AccountID payerId, long activeNodeCredit) {
        V0610TokenSchema.dispatchSynthNodeRewards(systemContext, activeNodeAccountIds, payerId, activeNodeCredit, List.of(), 0L);
    }

    public static void dispatchSynthNodeRewards(@NonNull SystemContext systemContext, @NonNull List<AccountID> activeNodeAccountIds, @NonNull AccountID payerId, long activeNodeCredit, @NonNull List<AccountID> inactiveNodeAccountIds, long inactiveNodeCredit) {
        if (activeNodeCredit <= 0L && inactiveNodeCredit <= 0L) {
            return;
        }
        long payerDebit = -(activeNodeCredit * (long)activeNodeAccountIds.size() + inactiveNodeCredit * (long)inactiveNodeAccountIds.size());
        ArrayList<AccountAmount> amounts = new ArrayList<AccountAmount>();
        if (activeNodeCredit > 0L) {
            amounts.addAll(V0610TokenSchema.accountAmountsFrom(activeNodeAccountIds, activeNodeCredit));
        }
        if (inactiveNodeCredit > 0L) {
            amounts.addAll(V0610TokenSchema.accountAmountsFrom(inactiveNodeAccountIds, inactiveNodeCredit));
        }
        amounts.add(TokenClaimAirdropHandler.asAccountAmount(payerId, payerDebit));
        systemContext.dispatchAdmin(b -> b.memo("Synthetic node rewards").cryptoTransfer(CryptoTransferTransactionBody.newBuilder().transfers(TransferList.newBuilder().accountAmounts((List)amounts).build())).build());
    }

    private static List<AccountAmount> accountAmountsFrom(@NonNull List<AccountID> nodeAccountIds, long amount) {
        return nodeAccountIds.stream().map(nodeAccountId -> TokenClaimAirdropHandler.asAccountAmount(nodeAccountId, amount)).toList();
    }
}

