/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.HssCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ReturnTypes;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.utils.ConstantUtils;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class DispatchForResponseCodeHssCall
extends AbstractCall {
    private final AccountID senderId;
    @Nullable
    private final TransactionBody syntheticBody;
    private final VerificationStrategy verificationStrategy;
    private final DispatchGasCalculator dispatchGasCalculator;
    private final Set<Key> authorizingKeys;
    private final DispatchOptions.UsePresetTxnId usePresetTxnId;
    private final Function<ContractCallStreamBuilder, ByteBuffer> resultEncoder;

    public DispatchForResponseCodeHssCall(@NonNull HssCallAttempt attempt, @Nullable TransactionBody syntheticBody, @NonNull DispatchGasCalculator dispatchGasCalculator, @NonNull Set<Key> authorizingKeys) {
        this(attempt.enhancement(), attempt.systemContractGasCalculator(), attempt.addressIdConverter().convertSender(attempt.senderAddress()), syntheticBody, attempt.defaultVerificationStrategy(), dispatchGasCalculator, authorizingKeys, e -> ReturnTypes.encodedRc(e.status()));
    }

    public DispatchForResponseCodeHssCall(@NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull SystemContractGasCalculator gasCalculator, @NonNull AccountID senderId, @Nullable TransactionBody syntheticBody, @NonNull VerificationStrategy verificationStrategy, @NonNull DispatchGasCalculator dispatchGasCalculator, @NonNull Set<Key> authorizingKeys, @NonNull Function<ContractCallStreamBuilder, ByteBuffer> resultEncoder) {
        super(gasCalculator, enhancement, false);
        this.senderId = Objects.requireNonNull(senderId);
        this.syntheticBody = syntheticBody;
        this.verificationStrategy = Objects.requireNonNull(verificationStrategy);
        this.dispatchGasCalculator = Objects.requireNonNull(dispatchGasCalculator);
        this.authorizingKeys = authorizingKeys;
        this.usePresetTxnId = syntheticBody != null && syntheticBody.hasTransactionID() ? DispatchOptions.UsePresetTxnId.YES : DispatchOptions.UsePresetTxnId.NO;
        this.resultEncoder = resultEncoder;
    }

    @Override
    @NonNull
    public Call.PricedResult execute(@NonNull MessageFrame frame) {
        if (this.syntheticBody == null) {
            return Call.PricedResult.gasOnly(FullResult.haltResult(CustomExceptionalHaltReason.ERROR_DECODING_PRECOMPILE_INPUT, FrameUtils.contractsConfigOf(frame).precompileHtsDefaultGasCost()), ResponseCodeEnum.INVALID_TRANSACTION_BODY, false);
        }
        ContractCallStreamBuilder recordBuilder = this.systemContractOperations().dispatch(this.syntheticBody, this.verificationStrategy, this.senderId, ContractCallStreamBuilder.class, this.authorizingKeys, this.usePresetTxnId);
        long gasRequirement = this.dispatchGasCalculator.gasRequirement(this.syntheticBody, this.gasCalculator, this.enhancement, this.senderId);
        return this.completionWith(gasRequirement, recordBuilder, this.resultEncoder.apply(recordBuilder));
    }

    public static ByteBuffer scheduleCreateResultEncode(@NonNull ContractCallStreamBuilder recordBuilder) {
        return ReturnTypes.RC_AND_ADDRESS_ENCODER.encode((Object)Tuple.of((Object)recordBuilder.status().protoOrdinal(), (Object)(recordBuilder.scheduleID() != null ? ConversionUtils.headlongAddressOf(recordBuilder.scheduleID()) : ConstantUtils.ZERO_ADDRESS)));
    }
}

