/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.airdrops;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.token.TokenAirdropTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.airdrops.TokenAirdropTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.LedgerConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenAirdropDecoder {
    private static final int TOKEN = 0;
    private static final int TOKEN_TRANSFERS = 1;
    private static final int NFT_AMOUNT = 2;
    private static final int TOKEN_ACCOUNT_ID = 0;
    private static final int TOKEN_AMOUNT = 1;
    private static final int TOKEN_IS_APPROVAL = 2;
    private static final int NFT_SENDER = 0;
    private static final int NFT_RECEIVER = 1;
    private static final int NFT_SERIAL = 2;
    private static final int NFT_IS_APPROVAL = 3;
    private static final Long LAST_RESERVED_SYSTEM_ACCOUNT = 1000L;

    @Inject
    public TokenAirdropDecoder() {
    }

    public TransactionBody decodeAirdrop(@NonNull HtsCallAttempt attempt) {
        Tuple call = TokenAirdropTranslator.TOKEN_AIRDROP.decodeCall(attempt.inputBytes());
        Tuple[] transferList = (Tuple[])call.get(0);
        LedgerConfig ledgerConfig = (LedgerConfig)attempt.configuration().getConfigData(LedgerConfig.class);
        TokenAirdropTransactionBody tokenAirdrop = this.bodyForAirdrop(transferList, attempt, ledgerConfig);
        return TransactionBody.newBuilder().tokenAirdrop(tokenAirdrop).build();
    }

    private TokenAirdropTransactionBody bodyForAirdrop(@NonNull Tuple[] transferList, @NonNull HtsCallAttempt attempt, @NonNull LedgerConfig ledgerConfig) {
        ArrayList transferBuilderList = new ArrayList();
        this.validateSemantics(transferList, ledgerConfig);
        Arrays.stream(transferList).forEach(transfer -> {
            TokenTransferList.Builder tokenTransferList = TokenTransferList.newBuilder();
            TokenID token = ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), (Address)transfer.get(0));
            tokenTransferList.token(token);
            Tuple[] tokenAmountsTuple = (Tuple[])transfer.get(1);
            Tuple[] nftAmountsTuple = (Tuple[])transfer.get(2);
            if (tokenAmountsTuple.length > 0) {
                ArrayList aaList = new ArrayList();
                Arrays.stream(tokenAmountsTuple).forEach(tokenAmount -> {
                    long amount = (Long)tokenAmount.get(1);
                    AccountID account = attempt.addressIdConverter().convert((Address)tokenAmount.get(0));
                    if (amount > 0L) {
                        this.checkForSystemAccount(account);
                    }
                    boolean isApproval = (Boolean)tokenAmount.get(2);
                    aaList.add(AccountAmount.newBuilder().amount(amount).accountID(account).isApproval(isApproval).build());
                });
                tokenTransferList.transfers(aaList);
            }
            if (nftAmountsTuple.length > 0) {
                ArrayList nftTransfersList = new ArrayList();
                Arrays.stream(nftAmountsTuple).forEach(nftAmount -> {
                    long serial = (Long)nftAmount.get(2);
                    AccountID sender = attempt.addressIdConverter().convert((Address)nftAmount.get(0));
                    AccountID receiver = attempt.addressIdConverter().convert((Address)nftAmount.get(1));
                    this.checkForSystemAccount(receiver);
                    boolean isApproval = (Boolean)nftAmount.get(3);
                    NftTransfer nftTransfer = NftTransfer.newBuilder().senderAccountID(sender).receiverAccountID(receiver).serialNumber(serial).isApproval(isApproval).build();
                    nftTransfersList.add(nftTransfer);
                });
                tokenTransferList.nftTransfers(nftTransfersList);
            }
            transferBuilderList.add(tokenTransferList.build());
        });
        return TokenAirdropTransactionBody.newBuilder().tokenTransfers(transferBuilderList).build();
    }

    private void validateSemantics(@NonNull Tuple[] transferList, @NonNull LedgerConfig ledgerConfig) {
        int fungibleBalanceChanges = 0;
        int nftBalanceChanges = 0;
        for (Tuple airdrop : transferList) {
            HandleException.validateFalse(((fungibleBalanceChanges += ((Tuple[])airdrop.get(1)).length) > ledgerConfig.tokenTransfersMaxLen() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_REFERENCE_LIST_SIZE_LIMIT_EXCEEDED);
            HandleException.validateFalse(((nftBalanceChanges += ((Tuple[])airdrop.get(2)).length) > ledgerConfig.nftTransfersMaxLen() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_REFERENCE_LIST_SIZE_LIMIT_EXCEEDED);
        }
    }

    private void checkForSystemAccount(@NonNull AccountID account) {
        HandleException.validateFalse((account.accountNumOrThrow() <= LAST_RESERVED_SYSTEM_ACCOUNT ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_RECEIVING_NODE_ACCOUNT);
    }
}

