/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import com.swirlds.common.Reservable;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import org.hiero.base.exceptions.ReferenceCountException;

public abstract class AbstractReservable
implements Reservable {
    private final AtomicInteger reservationCount = new AtomicInteger(0);
    private static final IntUnaryOperator RESERVE = current -> {
        if (current == -1) {
            throw new ReferenceCountException("can not reserve node that has already been destroyed");
        }
        return current + 1;
    };
    private static final IntUnaryOperator TRY_RESERVE = current -> {
        if (current == -1) {
            return current;
        }
        return current + 1;
    };
    private static final IntUnaryOperator RELEASE = current -> {
        if (current == -1) {
            throw new ReferenceCountException("can not release node that has already been destroyed");
        }
        if (current == 0 || current == 1) {
            return -1;
        }
        return current - 1;
    };

    @Override
    public void reserve() {
        try {
            this.reservationCount.updateAndGet(RESERVE);
        }
        catch (ReferenceCountException e) {
            this.onReferenceCountException();
            throw e;
        }
    }

    @Override
    public boolean tryReserve() {
        return this.reservationCount.updateAndGet(TRY_RESERVE) != -1;
    }

    @Override
    public boolean release() {
        int newReservationCount;
        try {
            newReservationCount = this.reservationCount.updateAndGet(RELEASE);
        }
        catch (ReferenceCountException e) {
            this.onReferenceCountException();
            throw e;
        }
        if (newReservationCount == -1) {
            this.onDestroy();
            return true;
        }
        return false;
    }

    @Override
    public boolean isDestroyed() {
        return this.reservationCount.get() == -1;
    }

    @Override
    public int getReservationCount() {
        return this.reservationCount.get();
    }

    protected void onDestroy() {
    }

    protected void onReferenceCountException() {
    }

    public void throwIfDestroyed(@NonNull String errorMessage) {
        this.onReferenceCountException();
        Reservable.super.throwIfDestroyed(errorMessage);
    }
}

