/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.api.intern;

import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.spi.ConfigurationBuilderFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class ConfigurationProvider {
    private final ConfigurationBuilderFactory factory = ConfigurationProvider.loadImplementation(ConfigurationProvider.class.getClassLoader());

    private ConfigurationProvider() {
    }

    @NonNull
    private static ConfigurationBuilderFactory loadImplementation(@NonNull ClassLoader classloader) {
        ServiceLoader<ConfigurationBuilderFactory> serviceLoader = ServiceLoader.load(ConfigurationBuilderFactory.class, classloader);
        Iterator<ConfigurationBuilderFactory> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new IllegalStateException("No ConfigurationBuilderFactory implementation found!");
    }

    public ConfigurationBuilder createBuilder() {
        return this.factory.create();
    }

    public static ConfigurationProvider getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static final class InstanceHolder {
        private static final ConfigurationProvider INSTANCE = new ConfigurationProvider();

        private InstanceHolder() {
        }
    }
}

