/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing;

import io.helidon.tracing.Baggage;
import io.helidon.tracing.HeaderConsumer;
import io.helidon.tracing.HeaderProvider;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanListener;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.WritableBaggage;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class NoOpTracer
implements Tracer {
    private static final NoOpTracer INSTANCE = new NoOpTracer();
    private static final SpanContext SPAN_CONTEXT = new SpanContext();
    private static final Builder BUILDER = new Builder();
    private static final Span SPAN = new Span();
    private static final Scope SCOPE = new Scope();
    private static final WritableBaggage EMPTY_BAGGAGE = new WritableBaggage(){

        @Override
        public Optional<String> get(String key) {
            return Optional.empty();
        }

        @Override
        public Set<String> keys() {
            return Set.of();
        }

        @Override
        public boolean containsKey(String key) {
            return false;
        }

        @Override
        public WritableBaggage set(String key, String value) {
            return this;
        }
    };

    private NoOpTracer() {
    }

    static Tracer instance() {
        return INSTANCE;
    }

    @Override
    public boolean enabled() {
        return false;
    }

    public Builder spanBuilder(String name) {
        return BUILDER;
    }

    @Override
    public Optional<io.helidon.tracing.SpanContext> extract(HeaderProvider headersProvider) {
        return Optional.empty();
    }

    @Override
    public void inject(io.helidon.tracing.SpanContext spanContext, HeaderProvider inboundHeadersProvider, HeaderConsumer outboundHeadersConsumer) {
    }

    @Override
    public <T> T unwrap(Class<T> tracerClass) {
        if (tracerClass.isInstance(this)) {
            return tracerClass.cast(this);
        }
        throw new IllegalArgumentException("Cannot provide an instance of " + tracerClass.getName() + ",  tracer is: " + this.getClass().getName());
    }

    @Override
    public Tracer register(SpanListener listener) {
        return this;
    }

    private static class Builder
    implements Span.Builder<Builder> {
        private Builder() {
        }

        public Span build() {
            return SPAN;
        }

        @Override
        public Builder parent(io.helidon.tracing.SpanContext spanContext) {
            return this;
        }

        @Override
        public Builder kind(Span.Kind kind) {
            return this;
        }

        @Override
        public Builder tag(String key, String value) {
            return this;
        }

        @Override
        public Builder tag(String key, Boolean value) {
            return this;
        }

        @Override
        public Builder tag(String key, Number value) {
            return this;
        }

        @Override
        public Span start(Instant instant) {
            return SPAN;
        }

        @Override
        public <T> T unwrap(Class<T> type) {
            return type.cast(this);
        }
    }

    private static class SpanContext
    implements io.helidon.tracing.SpanContext {
        private SpanContext() {
        }

        @Override
        public String traceId() {
            return "no-op";
        }

        @Override
        public String spanId() {
            return "no-op";
        }

        @Override
        public void asParent(Span.Builder<?> spanBuilder) {
        }

        @Override
        public Baggage baggage() {
            return EMPTY_BAGGAGE;
        }
    }

    private static class Span
    implements io.helidon.tracing.Span {
        private Span() {
        }

        @Override
        public io.helidon.tracing.Span tag(String key, String value) {
            return this;
        }

        @Override
        public io.helidon.tracing.Span tag(String key, Boolean value) {
            return this;
        }

        @Override
        public io.helidon.tracing.Span tag(String key, Number value) {
            return this;
        }

        @Override
        public void status(Span.Status status) {
        }

        @Override
        public SpanContext context() {
            return SPAN_CONTEXT;
        }

        @Override
        public void addEvent(String name, Map<String, ?> attributes) {
        }

        @Override
        public void end() {
        }

        @Override
        public void end(Throwable t) {
        }

        @Override
        public Scope activate() {
            return SCOPE;
        }

        @Override
        public Span baggage(String key, String value) {
            return this;
        }

        @Override
        public Optional<String> baggage(String key) {
            return Optional.empty();
        }

        @Override
        public <T> T unwrap(Class<T> spanClass) {
            return spanClass.cast(this);
        }

        @Override
        public WritableBaggage baggage() {
            return EMPTY_BAGGAGE;
        }
    }

    private static class Scope
    implements io.helidon.tracing.Scope {
        private Scope() {
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isClosed() {
            return true;
        }
    }
}

