/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming.config;

import com.hedera.node.app.blocks.impl.streaming.config.BlockNodeHelidonGrpcConfiguration;
import com.hedera.node.app.blocks.impl.streaming.config.BlockNodeHelidonHttpConfiguration;
import com.hedera.node.internal.network.BlockNodeConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class BlockNodeConfiguration {
    public static final long DEFAULT_MESSAGE_SOFT_LIMIT_BYTES = 0x200000L;
    public static final long DEFAULT_MESSAGE_HARD_LIMIT_BYTES = 0x600400L;
    private final String address;
    private final int port;
    private final int priority;
    private final long messageSizeSoftLimitBytes;
    private final long messageSizeHardLimitBytes;
    private final BlockNodeHelidonHttpConfiguration clientHttpConfig;
    private final BlockNodeHelidonGrpcConfiguration clientGrpcConfig;

    private BlockNodeConfiguration(Builder builder) {
        this.address = Objects.requireNonNull(builder.address, "Address must be specified");
        this.clientHttpConfig = Objects.requireNonNull(builder.clientHttpConfig, "Client HTTP config must be specified");
        this.clientGrpcConfig = Objects.requireNonNull(builder.clientGrpcConfig, "Client gRPC config must be specified");
        this.port = builder.port;
        this.priority = builder.priority;
        this.messageSizeSoftLimitBytes = builder.messageSizeSoftLimitBytes;
        this.messageSizeHardLimitBytes = builder.messageSizeHardLimitBytes;
        if (this.address.isBlank()) {
            throw new IllegalArgumentException("Address must not be empty");
        }
        if (this.port < 1) {
            throw new IllegalArgumentException("Port must be greater than or equal to 1");
        }
        if (this.priority < 0) {
            throw new IllegalArgumentException("Priority must be greater than or equal to 0");
        }
        if (this.messageSizeSoftLimitBytes <= 0L) {
            throw new IllegalArgumentException("Message size soft limit must be greater than 0");
        }
        if (this.messageSizeHardLimitBytes < this.messageSizeSoftLimitBytes) {
            throw new IllegalArgumentException("Message size hard limit must be greater than or equal to soft limit size");
        }
    }

    @NonNull
    public String address() {
        return this.address;
    }

    public int port() {
        return this.port;
    }

    public int priority() {
        return this.priority;
    }

    public long messageSizeSoftLimitBytes() {
        return this.messageSizeSoftLimitBytes;
    }

    public long messageSizeHardLimitBytes() {
        return this.messageSizeHardLimitBytes;
    }

    @NonNull
    public BlockNodeHelidonHttpConfiguration clientHttpConfig() {
        return this.clientHttpConfig;
    }

    @NonNull
    public BlockNodeHelidonGrpcConfiguration clientGrpcConfig() {
        return this.clientGrpcConfig;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockNodeConfiguration that = (BlockNodeConfiguration)o;
        return this.port == that.port && this.priority == that.priority && this.messageSizeSoftLimitBytes == that.messageSizeSoftLimitBytes && this.messageSizeHardLimitBytes == that.messageSizeHardLimitBytes && Objects.equals(this.address, that.address) && Objects.equals(this.clientHttpConfig, that.clientHttpConfig) && Objects.equals(this.clientGrpcConfig, that.clientGrpcConfig);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.port, this.priority, this.messageSizeSoftLimitBytes, this.messageSizeHardLimitBytes, this.clientHttpConfig, this.clientGrpcConfig);
    }

    @NonNull
    public static BlockNodeConfiguration from(@NonNull BlockNodeConfig config) {
        Objects.requireNonNull(config, "config must be specified");
        Builder b = BlockNodeConfiguration.newBuilder();
        b.address(config.address());
        b.port(config.port());
        b.priority(config.priority());
        b.messageSizeSoftLimitBytes(config.messageSizeSoftLimitBytesOrElse(Long.valueOf(0x200000L)));
        b.messageSizeHardLimitBytes(config.messageSizeHardLimitBytesOrElse(Long.valueOf(0x600400L)));
        b.clientGrpcConfig(BlockNodeHelidonGrpcConfiguration.from(config.clientGrpcConfig()));
        b.clientHttpConfig(BlockNodeHelidonHttpConfiguration.from(config.clientHttpConfig()));
        return b.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String address;
        private int port;
        private int priority;
        private long messageSizeSoftLimitBytes;
        private long messageSizeHardLimitBytes;
        private BlockNodeHelidonGrpcConfiguration clientGrpcConfig;
        private BlockNodeHelidonHttpConfiguration clientHttpConfig;

        private Builder() {
        }

        @NonNull
        public Builder address(String address) {
            this.address = address;
            return this;
        }

        @NonNull
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @NonNull
        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @NonNull
        public Builder messageSizeSoftLimitBytes(long messageSizeSoftLimitBytes) {
            this.messageSizeSoftLimitBytes = messageSizeSoftLimitBytes;
            return this;
        }

        @NonNull
        public Builder messageSizeHardLimitBytes(long messageSizeHardLimitBytes) {
            this.messageSizeHardLimitBytes = messageSizeHardLimitBytes;
            return this;
        }

        @NonNull
        public Builder clientHttpConfig(@NonNull BlockNodeHelidonHttpConfiguration clientHttpConfig) {
            this.clientHttpConfig = clientHttpConfig;
            return this;
        }

        @NonNull
        public Builder clientGrpcConfig(@NonNull BlockNodeHelidonGrpcConfiguration clientGrpcConfig) {
            this.clientGrpcConfig = clientGrpcConfig;
            return this;
        }

        public BlockNodeConfiguration build() {
            return new BlockNodeConfiguration(this);
        }
    }
}

