/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.components.consensus;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.hiero.consensus.hashgraph.FreezeCheckHolder;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.EventWindow;

public class FreezeRoundController {
    private final FreezeCheckHolder freezeChecker;
    private boolean isFrozen = false;

    public FreezeRoundController(@NonNull FreezeCheckHolder freezeChecker) {
        this.freezeChecker = Objects.requireNonNull(freezeChecker);
    }

    public List<ConsensusRound> filterAndModify(@NonNull List<ConsensusRound> consensusRounds) {
        if (consensusRounds.stream().map(ConsensusRound::getConsensusTimestamp).noneMatch((Predicate<Instant>)this.freezeChecker)) {
            return consensusRounds;
        }
        this.isFrozen = true;
        ArrayList<ConsensusRound> modifiedRounds = new ArrayList<ConsensusRound>();
        for (ConsensusRound round : consensusRounds) {
            if (this.freezeChecker.test(round.getConsensusTimestamp())) {
                modifiedRounds.add(FreezeRoundController.modifyFreezeRound(round));
                return modifiedRounds;
            }
            modifiedRounds.add(round);
        }
        return modifiedRounds;
    }

    private static ConsensusRound modifyFreezeRound(@NonNull ConsensusRound round) {
        EventWindow modifiedWindow = new EventWindow(round.getEventWindow().latestConsensusRound(), round.getEventWindow().latestConsensusRound(), round.getEventWindow().ancientThreshold(), round.getEventWindow().expiredThreshold());
        return new ConsensusRound(round.getConsensusRoster(), round.getConsensusEvents(), modifiedWindow, round.getSnapshot(), round.isPcesRound(), round.getReachedConsTimestamp());
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }
}

