/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.hashgraph;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.hiero.consensus.hashgraph.FreezePeriodChecker;

public class FreezeCheckHolder
implements FreezePeriodChecker,
Predicate<Instant> {
    private final AtomicReference<Predicate<Instant>> freezeCheckRef = new AtomicReference();

    @Override
    public boolean isInFreezePeriod(@NonNull Instant timestamp) {
        Predicate<Instant> isInFreezePeriod = this.freezeCheckRef.get();
        if (isInFreezePeriod == null) {
            throw new IllegalStateException("A freeze check has not been provided to the holder");
        }
        return isInFreezePeriod.test(Objects.requireNonNull(timestamp));
    }

    public void setFreezeCheckRef(@NonNull Predicate<Instant> freezeCheckRef) {
        this.freezeCheckRef.set(Objects.requireNonNull(freezeCheckRef));
    }

    @Override
    public boolean test(@NonNull Instant instant) {
        return this.isInFreezePeriod(instant);
    }
}

