/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metadata;

import io.helidon.metadata.MetadataFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

class MetadataFileImpl
implements MetadataFile {
    private static final System.Logger LOGGER = System.getLogger(MetadataFileImpl.class.getName());
    private final String fileName;
    private final String location;
    private final Supplier<InputStream> inputStreamSupplier;
    private final String absolutePath;

    private MetadataFileImpl(String fileName, String location, String absolutePath, Supplier<InputStream> inputStreamSupplier) {
        this.fileName = fileName;
        this.location = location;
        this.absolutePath = absolutePath;
        this.inputStreamSupplier = inputStreamSupplier;
    }

    static MetadataFile create(String location, String fileName, URL resourceUrl) {
        String absolutePath = resourceUrl.getPath();
        return new MetadataFileImpl(fileName, location, absolutePath, () -> {
            try {
                if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                    LOGGER.log(System.Logger.Level.DEBUG, "Open stream for resource: {0}, location: {1}, absolute location: {2}", fileName, location, absolutePath);
                }
                return resourceUrl.openStream();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to open input stream for URL: " + String.valueOf(resourceUrl), e);
            }
        });
    }

    static MetadataFile create(String location, String fileName, Path resourcepath) {
        String absoluteLocation = resourcepath.toAbsolutePath().normalize().toString();
        return new MetadataFileImpl(fileName, location, absoluteLocation, () -> {
            try {
                if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                    LOGGER.log(System.Logger.Level.DEBUG, "Open stream for file: {0}, location: {1}, absolute location: {2}", fileName, location, absoluteLocation);
                }
                return Files.newInputStream(resourcepath, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to open input stream for path: " + String.valueOf(resourcepath), e);
            }
        });
    }

    static MetadataFile create(Path zipFile, String location, String fileName, Path file) {
        String absoluteLocation = zipFile.toAbsolutePath().normalize().toString() + String.valueOf(file.toAbsolutePath().normalize());
        return new MetadataFileImpl(fileName, location, absoluteLocation, () -> {
            ByteArrayInputStream byteArrayInputStream;
            block9: {
                if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                    LOGGER.log(System.Logger.Level.DEBUG, "Open stream for file: {0}, location: {1}, absolute location: {2}", fileName, location, absoluteLocation);
                }
                FileSystem fs = FileSystems.newFileSystem(zipFile, Map.of());
                try {
                    Path fsPath = fs.getPath(file.toString(), new String[0]);
                    byte[] bytes = Files.readAllBytes(fsPath);
                    byteArrayInputStream = new ByteArrayInputStream(bytes);
                    if (fs == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (fs != null) {
                            try {
                                fs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to open input stream for path: " + absoluteLocation, e);
                    }
                }
                fs.close();
            }
            return byteArrayInputStream;
        });
    }

    public String toString() {
        return "MetadatumImpl{fileName='" + this.fileName + "', location='" + this.location + "', absolutePath='" + this.absolutePath + "'}";
    }

    @Override
    public String absoluteLocation() {
        return this.absolutePath;
    }

    @Override
    public String fileName() {
        return this.fileName;
    }

    @Override
    public InputStream inputStream() {
        return this.inputStreamSupplier.get();
    }

    @Override
    public String location() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MetadataFileImpl)) {
            return false;
        }
        MetadataFileImpl that = (MetadataFileImpl)o;
        return Objects.equals(this.fileName, that.fileName) && Objects.equals(this.location, that.location) && Objects.equals(this.absolutePath, that.absolutePath);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.location, this.absolutePath);
    }
}

