/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.consensus;

import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.JudgeId;
import com.hedera.hapi.platform.state.MinimumJudgeInfo;
import com.swirlds.platform.consensus.ConsensusUtils;
import com.swirlds.platform.consensus.RoundCalculationUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.List;
import java.util.stream.LongStream;
import org.hiero.base.utility.CommonUtils;
import org.hiero.consensus.hashgraph.ConsensusConfig;
import org.hiero.consensus.model.event.PlatformEvent;

@Deprecated(forRemoval=true, since="0.63.0")
public final class SyntheticSnapshot {
    private SyntheticSnapshot() {
    }

    @NonNull
    public static ConsensusSnapshot generateSyntheticSnapshot(long round, long lastConsensusOrder, @NonNull Instant roundTimestamp, @NonNull ConsensusConfig config, @NonNull PlatformEvent judge) {
        List<MinimumJudgeInfo> minimumJudgeInfos = LongStream.range(RoundCalculationUtils.getOldestNonAncientRound(config.roundsNonAncient(), round), round + 1L).mapToObj(r -> new MinimumJudgeInfo(r, judge.getBirthRound())).toList();
        return ConsensusSnapshot.newBuilder().round(round).judgeIds(List.of(JudgeId.newBuilder().creatorId(judge.getCreatorId().id()).judgeHash(judge.getHash().getBytes()).build())).minimumJudgeInfoList(minimumJudgeInfos).nextConsensusNumber(lastConsensusOrder + 1L).consensusTimestamp(CommonUtils.toPbjTimestamp((Instant)ConsensusUtils.calcMinTimestampForNextEvent(roundTimestamp))).build();
    }

    @NonNull
    public static ConsensusSnapshot getGenesisSnapshot() {
        return ConsensusSnapshot.newBuilder().round(1L).judgeIds(List.of()).minimumJudgeInfoList(List.of(new MinimumJudgeInfo(1L, 1L))).nextConsensusNumber(0L).consensusTimestamp(CommonUtils.toPbjTimestamp((Instant)Instant.EPOCH)).build();
    }
}

