/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.hyperledger.besu.crypto.SECPSignature;

public class CodeDelegationSignature
extends SECPSignature {
    private static final BigInteger TWO_POW_256 = BigInteger.TWO.pow(256);

    public CodeDelegationSignature(BigInteger r, BigInteger s, byte yParity) {
        super(r, s, yParity);
    }

    public static CodeDelegationSignature create(BigInteger r, BigInteger s, byte yParity) {
        Preconditions.checkNotNull((Object)r);
        Preconditions.checkNotNull((Object)s);
        if (r.compareTo(TWO_POW_256) >= 0) {
            throw new IllegalArgumentException("Invalid 'r' value, should be < 2^256 but got " + r.toString(16));
        }
        if (s.compareTo(TWO_POW_256) >= 0) {
            throw new IllegalArgumentException("Invalid 's' value, should be < 2^256 but got " + s.toString(16));
        }
        return new CodeDelegationSignature(r, s, yParity);
    }
}

