/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.counters;

import com.swirlds.component.framework.counters.EmptyBlocker;
import com.swirlds.component.framework.counters.ObjectCounter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class BackpressureObjectCounter
extends ObjectCounter {
    private final String name;
    private final AtomicLong count = new AtomicLong(0L);
    private final long capacity;
    private final long sleepNanos;
    private final ForkJoinPool.ManagedBlocker waitUntilEmptyBlocker;

    public BackpressureObjectCounter(@NonNull String name, long capacity, @NonNull Duration sleepDuration) {
        if (capacity <= 0L) {
            throw new IllegalArgumentException("Capacity must be greater than zero");
        }
        this.name = Objects.requireNonNull(name);
        this.capacity = capacity;
        this.sleepNanos = sleepDuration.toNanos();
        this.waitUntilEmptyBlocker = new EmptyBlocker(this.count, this.sleepNanos);
    }

    @Override
    public void onRamp(final long delta) {
        if (this.attemptOnRamp(delta)) {
            return;
        }
        while (true) {
            try {
                ForkJoinPool.managedBlock(new ForkJoinPool.ManagedBlocker(){

                    @Override
                    public boolean block() throws InterruptedException {
                        if (BackpressureObjectCounter.this.sleepNanos > 0L) {
                            try {
                                TimeUnit.NANOSECONDS.sleep(BackpressureObjectCounter.this.sleepNanos);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        return false;
                    }

                    @Override
                    public boolean isReleasable() {
                        return BackpressureObjectCounter.this.attemptOnRamp(delta);
                    }
                });
                return;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while blocking on an onRamp() for " + this.name);
            }
            catch (RejectedExecutionException ex) {
                Thread.onSpinWait();
                continue;
            }
            break;
        }
    }

    @Override
    public boolean attemptOnRamp(long delta) {
        long resultingCount = this.count.addAndGet(delta);
        if (resultingCount <= this.capacity) {
            return true;
        }
        this.count.addAndGet(-delta);
        return false;
    }

    @Override
    public void forceOnRamp(long delta) {
        this.count.addAndGet(delta);
    }

    @Override
    public void offRamp(long delta) {
        this.count.addAndGet(-delta);
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    @Override
    public void waitUntilEmpty() {
        if (this.count.get() == 0L) {
            return;
        }
        try {
            ForkJoinPool.managedBlock(this.waitUntilEmptyBlocker);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while blocking on an waitUntilEmpty() for " + this.name);
        }
    }
}

