/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.configurable.Resource;
import io.helidon.common.configurable.ResourceConfig;
import io.helidon.common.configurable.ResourceException;
import io.helidon.common.configurable.ResourceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

final class ResourceUtil {
    private ResourceUtil() {
    }

    static Resource from(InputStream inputStream, String description, Resource.Source resourceSource) {
        return new ResourceImpl(((ResourceConfig.Builder)ResourceConfig.builder().description(description)).buildPrototype(), resourceSource, inputStream);
    }

    static InputStream toIs(Path fsPath) {
        Objects.requireNonNull(fsPath, "Resource file system path must not be null");
        try {
            return Files.newInputStream(fsPath, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ResourceException("Resource on path: " + String.valueOf(fsPath.toAbsolutePath()) + " does not exist", e);
        }
    }

    static InputStream toIs(String resPath) {
        Objects.requireNonNull(resPath, "Resource path must not be null");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resPath);
        Objects.requireNonNull(is, "Resource path does not exist: " + resPath);
        return is;
    }

    static InputStream toIs(URI uri) {
        try {
            return uri.toURL().openStream();
        }
        catch (IOException e) {
            throw new ResourceException("Failed to open stream to uri: " + String.valueOf(uri), e);
        }
    }

    static InputStream toIs(URI uri, Proxy proxy) {
        try {
            return uri.toURL().openConnection(proxy).getInputStream();
        }
        catch (IOException e) {
            throw new ResourceException("Failed to open stream to uri: " + String.valueOf(uri), e);
        }
    }
}

