/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.concurrency.limits;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.concurrency.limits.FixedLimitConfig;
import io.helidon.common.concurrency.limits.IgnoreTaskException;
import io.helidon.common.concurrency.limits.Limit;
import io.helidon.common.concurrency.limits.LimitAlgorithm;
import io.helidon.common.concurrency.limits.LimitAlgorithmDeprecatedBase;
import io.helidon.common.concurrency.limits.LimitException;
import io.helidon.common.concurrency.limits.LimitHandlers;
import io.helidon.common.concurrency.limits.SemaphoreLimit;
import io.helidon.common.config.Config;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.Metrics;
import io.helidon.metrics.api.MetricsFactory;
import io.helidon.metrics.api.Tag;
import io.helidon.metrics.api.Timer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;

@RuntimeType.PrototypedBy(value=FixedLimitConfig.class)
public class FixedLimit
extends LimitAlgorithmDeprecatedBase
implements Limit,
SemaphoreLimit,
RuntimeType.Api<FixedLimitConfig> {
    public static final int DEFAULT_LIMIT = 0;
    public static final int DEFAULT_QUEUE_LENGTH = 0;
    public static final String DEFAULT_QUEUE_TIMEOUT_DURATION = "PT1S";
    static final String TYPE = "fixed";
    private final FixedLimitConfig config;
    private final LimitHandlers.LimiterHandler handler;
    private final int initialPermits;
    private final Semaphore semaphore;
    private final Supplier<Long> clock;
    private final AtomicInteger concurrentRequests;
    private final AtomicInteger rejectedRequests;
    private final int queueLength;
    private Timer rttTimer;
    private Timer queueWaitTimer;
    private String originName;

    private FixedLimit(FixedLimitConfig config) {
        this.config = config;
        this.concurrentRequests = new AtomicInteger();
        this.rejectedRequests = new AtomicInteger();
        this.clock = config.clock().orElseGet(() -> System::nanoTime);
        if (config.permits() == 0 && config.semaphore().isEmpty()) {
            this.semaphore = null;
            this.initialPermits = 0;
            this.queueLength = 0;
            this.handler = new LimitHandlers.NoOpSemaphoreHandler();
        } else {
            this.semaphore = config.semaphore().orElseGet(() -> new Semaphore(config.permits(), config.fair()));
            this.initialPermits = this.semaphore.availablePermits();
            this.queueLength = Math.max(0, config.queueLength());
            this.handler = new LimitHandlers.QueuedSemaphoreHandler(this.semaphore, this.queueLength, config.queueTimeout(), () -> new FixedToken(this.clock, this.concurrentRequests));
        }
    }

    public static FixedLimitConfig.Builder builder() {
        return FixedLimitConfig.builder();
    }

    public static FixedLimit create() {
        return FixedLimit.builder().build();
    }

    public static FixedLimit create(Semaphore semaphore) {
        return ((FixedLimitConfig.Builder)FixedLimit.builder().semaphore(semaphore)).build();
    }

    public static FixedLimit create(Config config) {
        return ((FixedLimitConfig.Builder)FixedLimit.builder().config(config)).build();
    }

    public static FixedLimit create(FixedLimitConfig config) {
        return new FixedLimit(config);
    }

    public static FixedLimit create(Consumer<FixedLimitConfig.Builder> consumer) {
        return ((FixedLimitConfig.Builder)FixedLimit.builder().update(consumer)).build();
    }

    @Override
    public LimitAlgorithm.Outcome tryAcquireOutcome(boolean wait) {
        return this.doTryAcquire(wait);
    }

    @Override
    public <T> LimitAlgorithm.Result<T> call(Callable<T> callable) throws Exception {
        return this.doInvoke(callable);
    }

    @Override
    public LimitAlgorithm.Outcome run(Runnable runnable) throws Exception {
        return this.doInvoke(() -> {
            runnable.run();
            return null;
        }).outcome();
    }

    @Override
    public Semaphore semaphore() {
        return this.handler.semaphore();
    }

    public FixedLimitConfig prototype() {
        return this.config;
    }

    public String name() {
        return this.config.name();
    }

    public String type() {
        return TYPE;
    }

    @Override
    public Limit copy() {
        if (this.config.semaphore().isPresent()) {
            Semaphore semaphore = this.config.semaphore().get();
            return ((FixedLimitConfig.Builder)((FixedLimitConfig.Builder)FixedLimitConfig.builder().from(this.config)).semaphore(new Semaphore(this.initialPermits, semaphore.isFair()))).build();
        }
        return (Limit)this.config.build();
    }

    @Override
    public void init(String socketName) {
        this.originName = socketName;
        if (this.config.enableMetrics()) {
            MetricsFactory metricsFactory = MetricsFactory.getInstance();
            MeterRegistry meterRegistry = Metrics.globalRegistry();
            Tag socketNameTag = null;
            if (!socketName.equals("@default")) {
                socketNameTag = Tag.create((String)"socketName", (String)socketName);
            }
            if (this.semaphore != null) {
                Gauge.Builder queueLengthBuilder = (Gauge.Builder)metricsFactory.gaugeBuilder(this.config.name() + "_queue_length", this.semaphore::getQueueLength).scope("vendor");
                if (socketNameTag != null) {
                    queueLengthBuilder.tags(List.of(socketNameTag));
                }
                meterRegistry.getOrCreate((Meter.Builder)queueLengthBuilder);
            }
            Gauge.Builder concurrentRequestsBuilder = (Gauge.Builder)metricsFactory.gaugeBuilder(this.config.name() + "_concurrent_requests", this.concurrentRequests::get).scope("vendor");
            if (socketNameTag != null) {
                concurrentRequestsBuilder.tags(List.of(socketNameTag));
            }
            meterRegistry.getOrCreate((Meter.Builder)concurrentRequestsBuilder);
            Gauge.Builder rejectedRequestsBuilder = (Gauge.Builder)metricsFactory.gaugeBuilder(this.config.name() + "_rejected_requests", this.rejectedRequests::get).scope("vendor");
            if (socketNameTag != null) {
                rejectedRequestsBuilder.tags(List.of(socketNameTag));
            }
            meterRegistry.getOrCreate((Meter.Builder)rejectedRequestsBuilder);
            Timer.Builder rttTimerBuilder = (Timer.Builder)((Timer.Builder)metricsFactory.timerBuilder(this.config.name() + "_rtt").scope("vendor")).baseUnit("milliseconds");
            if (socketNameTag != null) {
                rttTimerBuilder.tags(List.of(socketNameTag));
            }
            this.rttTimer = (Timer)meterRegistry.getOrCreate((Meter.Builder)rttTimerBuilder);
            Timer.Builder waitTimerBuilder = (Timer.Builder)((Timer.Builder)metricsFactory.timerBuilder(this.config.name() + "_queue_wait_time").scope("vendor")).baseUnit("milliseconds");
            if (socketNameTag != null) {
                waitTimerBuilder.tags(List.of(socketNameTag));
            }
            this.queueWaitTimer = (Timer)meterRegistry.getOrCreate((Meter.Builder)waitTimerBuilder);
        }
    }

    void updateMetrics(long startTime, long endTime) {
        long rtt = endTime - startTime;
        if (this.rttTimer != null) {
            this.rttTimer.record(rtt, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    @Deprecated(since="4.3.0", forRemoval=true)
    LimitAlgorithm.Outcome doTryAcquireObs(boolean wait) {
        return this.doTryAcquire(wait);
    }

    @Override
    @Deprecated(since="4.3.0", forRemoval=true)
    <T> LimitAlgorithm.Result<T> doInvokeObs(Callable<T> callable) throws Exception {
        return this.doInvoke(callable);
    }

    private LimitAlgorithm.Outcome doTryAcquire(boolean wait) {
        Optional<LimitAlgorithm.Token> token = this.handler.tryAcquireToken(false);
        if (token.isPresent()) {
            return LimitAlgorithm.Outcome.immediateAcceptance(this.originName, TYPE, token.get());
        }
        if (wait && this.queueLength > 0) {
            long startWait = this.clock.get();
            token = this.handler.tryAcquireToken(true);
            long endWait = this.clock.get();
            if (token.isPresent()) {
                if (this.queueWaitTimer != null) {
                    this.queueWaitTimer.record(endWait - startWait, TimeUnit.NANOSECONDS);
                }
                return LimitAlgorithm.Outcome.deferredAcceptance(this.originName, TYPE, token.get(), startWait, endWait);
            }
            return LimitAlgorithm.Outcome.deferredRejection(this.originName, TYPE, startWait, endWait);
        }
        this.rejectedRequests.getAndIncrement();
        return LimitAlgorithm.Outcome.immediateRejection(this.originName, TYPE);
    }

    private <T> LimitAlgorithm.Result<T> doInvoke(Callable<T> callable) throws Exception {
        LimitAlgorithm.Outcome outcome = this.doTryAcquire(true);
        if (outcome instanceof LimitAlgorithm.Outcome.Accepted) {
            LimitAlgorithm.Outcome.Accepted accepted = (LimitAlgorithm.Outcome.Accepted)outcome;
            LimitAlgorithm.Token token = accepted.token();
            try {
                this.concurrentRequests.getAndIncrement();
                long startTime = this.clock.get();
                T response = callable.call();
                if (this.rttTimer != null) {
                    this.rttTimer.record(this.clock.get() - startTime, TimeUnit.NANOSECONDS);
                }
                token.success();
                LimitAlgorithm.Result<T> result = LimitAlgorithm.Result.create(response, outcome);
                return result;
            }
            catch (IgnoreTaskException e) {
                token.ignore();
                LimitAlgorithm.Result result = LimitAlgorithm.Result.create(e.handle(), outcome);
                return result;
            }
            catch (Throwable e) {
                token.dropped();
                throw e;
            }
            finally {
                this.concurrentRequests.getAndDecrement();
            }
        }
        throw new LimitException("No more permits available for the semaphore");
    }

    private class FixedToken
    implements LimitAlgorithm.Token {
        private final long startTime;

        private FixedToken(Supplier<Long> clock, AtomicInteger concurrentRequests) {
            this.startTime = clock.get();
            concurrentRequests.incrementAndGet();
        }

        @Override
        public void dropped() {
            try {
                FixedLimit.this.updateMetrics(this.startTime, FixedLimit.this.clock.get());
            }
            finally {
                FixedLimit.this.semaphore.release();
            }
        }

        @Override
        public void ignore() {
            FixedLimit.this.concurrentRequests.decrementAndGet();
            FixedLimit.this.semaphore.release();
        }

        @Override
        public void success() {
            try {
                FixedLimit.this.updateMetrics(this.startTime, FixedLimit.this.clock.get());
                FixedLimit.this.concurrentRequests.decrementAndGet();
            }
            finally {
                FixedLimit.this.semaphore.release();
            }
        }
    }
}

