/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class ContractIDJsonCodec
implements JsonCodec<ContractID> {
    public static final OneOf<ContractID.ContractOneOfType> CONTRACT_UNSET = new OneOf((Enum)ContractID.ContractOneOfType.UNSET, null);

    @NonNull
    public ContractID parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_shardNum = 0L;
            long temp_realmNum = 0L;
            OneOf temp_contract = CONTRACT_UNSET;
            block14: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "shardNum": {
                        temp_shardNum = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block14;
                    }
                    case "realmNum": {
                        temp_realmNum = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block14;
                    }
                    case "contractNum": {
                        temp_contract = new OneOf((Enum)ContractID.ContractOneOfType.CONTRACT_NUM, (Object)JsonTools.parseLong((JSONParser.ValueContext)kvPair.value()));
                        continue block14;
                    }
                    case "evmAddress": {
                        temp_contract = new OneOf((Enum)ContractID.ContractOneOfType.EVM_ADDRESS, (Object)Bytes.fromBase64((String)JsonTools.checkSize((String)"evm_address", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE))));
                        continue block14;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new ContractID(temp_shardNum, temp_realmNum, temp_contract);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull ContractID data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.shardNum() != 0L) {
            fieldLines.add(JsonTools.field((String)"shardNum", (long)data.shardNum()));
        }
        if (data.realmNum() != 0L) {
            fieldLines.add(JsonTools.field((String)"realmNum", (long)data.realmNum()));
        }
        if (data.contract().kind() == ContractID.ContractOneOfType.CONTRACT_NUM) {
            fieldLines.add(JsonTools.field((String)"contractNum", (long)data.contractNum()));
        }
        if (data.contract().kind() == ContractID.ContractOneOfType.EVM_ADDRESS) {
            fieldLines.add(JsonTools.field((String)"evmAddress", (Bytes)data.evmAddress()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

