/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.crypto;

import com.hedera.node.app.hapi.fees.usage.crypto.AllowanceId;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoContextUtils;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hederahashgraph.api.proto.java.GrantedCryptoAllowance;
import com.hederahashgraph.api.proto.java.GrantedNftAllowance;
import com.hederahashgraph.api.proto.java.GrantedTokenAllowance;
import com.hederahashgraph.api.proto.java.Key;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExtantCryptoContext {
    private final int currentNumTokenRels;
    private final Key currentKey;
    private final long currentExpiry;
    private final String currentMemo;
    private final boolean currentlyHasProxy;
    private final int currentMaxAutomaticAssociations;
    private final Map<Long, Long> currentCryptoAllowances;
    private final Map<AllowanceId, Long> currentTokenAllowances;
    private final Set<AllowanceId> currentApproveForAllNftAllowances;

    private ExtantCryptoContext(Builder builder) {
        this.currentNumTokenRels = builder.currentNumTokenRels;
        this.currentMemo = builder.currentMemo;
        this.currentExpiry = builder.currentExpiry;
        this.currentKey = builder.currentKey;
        this.currentlyHasProxy = builder.currentlyHasProxy;
        this.currentMaxAutomaticAssociations = builder.currentMaxAutomaticAssociations;
        this.currentCryptoAllowances = builder.currentCryptoAllowances;
        this.currentTokenAllowances = builder.currentTokenAllowances;
        this.currentApproveForAllNftAllowances = builder.currentApproveForAllNftAllowances;
    }

    public long currentNonBaseRb() {
        return (long)(this.currentlyHasProxy ? 24 : 0) + (long)this.currentMemo.getBytes(StandardCharsets.UTF_8).length + (long)FeeBuilder.getAccountKeyStorageSize((Key)this.currentKey) + (long)(this.currentMaxAutomaticAssociations == 0 ? 0 : 4);
    }

    public Key currentKey() {
        return this.currentKey;
    }

    public int currentNumTokenRels() {
        return this.currentNumTokenRels;
    }

    public long currentExpiry() {
        return this.currentExpiry;
    }

    public String currentMemo() {
        return this.currentMemo;
    }

    public boolean currentlyHasProxy() {
        return this.currentlyHasProxy;
    }

    public int currentMaxAutomaticAssociations() {
        return this.currentMaxAutomaticAssociations;
    }

    public Map<Long, Long> currentCryptoAllowances() {
        return this.currentCryptoAllowances;
    }

    public Map<AllowanceId, Long> currentTokenAllowances() {
        return this.currentTokenAllowances;
    }

    public Set<AllowanceId> currentNftAllowances() {
        return this.currentApproveForAllNftAllowances;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private static final int HAS_PROXY_MASK = 1;
        private static final int EXPIRY_MASK = 2;
        private static final int MEMO_MASK = 4;
        private static final int KEY_MASK = 8;
        private static final int TOKEN_RELS_MASK = 16;
        private static final int MAX_AUTO_ASSOCIATIONS_MASK = 32;
        private static final int CRYPTO_ALLOWANCES_MASK = 64;
        private static final int TOKEN_ALLOWANCES_MASK = 128;
        private static final int NFT_ALLOWANCES_MASK = 256;
        private static final int ALL_FIELDS_MASK = 511;
        private int mask = 0;
        private int currentNumTokenRels;
        private Key currentKey;
        private String currentMemo;
        private boolean currentlyHasProxy;
        private long currentExpiry;
        private int currentMaxAutomaticAssociations;
        private Map<Long, Long> currentCryptoAllowances;
        private Map<AllowanceId, Long> currentTokenAllowances;
        private Set<AllowanceId> currentApproveForAllNftAllowances;

        private Builder() {
        }

        public ExtantCryptoContext build() {
            if (this.mask != 511) {
                throw new IllegalStateException(String.format("Field mask is %d, not %d!", this.mask, 511));
            }
            return new ExtantCryptoContext(this);
        }

        public Builder setCurrentNumTokenRels(int currentNumTokenRels) {
            this.currentNumTokenRels = currentNumTokenRels;
            this.mask |= 0x10;
            return this;
        }

        public Builder setCurrentExpiry(long currentExpiry) {
            this.currentExpiry = currentExpiry;
            this.mask |= 2;
            return this;
        }

        public Builder setCurrentMemo(String currentMemo) {
            this.currentMemo = currentMemo;
            this.mask |= 4;
            return this;
        }

        public Builder setCurrentKey(Key currentKey) {
            this.currentKey = currentKey;
            this.mask |= 8;
            return this;
        }

        public Builder setCurrentlyHasProxy(boolean currentlyHasProxy) {
            this.currentlyHasProxy = currentlyHasProxy;
            this.mask |= 1;
            return this;
        }

        public Builder setCurrentMaxAutomaticAssociations(int currentMaxAutomaticAssociations) {
            this.currentMaxAutomaticAssociations = currentMaxAutomaticAssociations;
            this.mask |= 0x20;
            return this;
        }

        public Builder setCurrentCryptoAllowances(Map<Long, Long> currentCryptoAllowances) {
            this.currentCryptoAllowances = currentCryptoAllowances;
            this.mask |= 0x40;
            return this;
        }

        public Builder setCurrentTokenAllowances(Map<AllowanceId, Long> currentTokenAllowances) {
            this.currentTokenAllowances = currentTokenAllowances;
            this.mask |= 0x80;
            return this;
        }

        public Builder setCurrentApproveForAllNftAllowances(Set<AllowanceId> currentApproveForAllNftAllowances) {
            this.currentApproveForAllNftAllowances = currentApproveForAllNftAllowances;
            this.mask |= 0x100;
            return this;
        }

        public Builder setCurrentCryptoAllowances(List<GrantedCryptoAllowance> grantedCryptoAllowancesList) {
            this.currentCryptoAllowances = CryptoContextUtils.convertToCryptoMapFromGranted(grantedCryptoAllowancesList);
            this.mask |= 0x40;
            return this;
        }

        public Builder setCurrentTokenAllowances(List<GrantedTokenAllowance> grantedTokenAllowancesList) {
            this.currentTokenAllowances = CryptoContextUtils.convertToTokenMapFromGranted(grantedTokenAllowancesList);
            this.mask |= 0x80;
            return this;
        }

        public Builder setCurrentApproveForAllNftAllowances(List<GrantedNftAllowance> grantedNftAllowancesList) {
            this.currentApproveForAllNftAllowances = CryptoContextUtils.convertToNftMapFromGranted(grantedNftAllowancesList);
            this.mask |= 0x100;
            return this;
        }
    }
}

