/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.editor;

import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.editor.StateEditorOperation;
import com.swirlds.platform.state.editor.StateEditorRoot;
import com.swirlds.platform.state.editor.StateEditorUtils;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="store", mixinStandardHelpOptions=true, description={"Store a subtree in a file."})
@SubcommandOf(value=StateEditorRoot.class)
public class StateEditorStore
extends StateEditorOperation {
    private static final Logger logger = LogManager.getLogger(StateEditorStore.class);
    private String path = "";
    private Path fileName;

    @CommandLine.Parameters(arity="0..1", description={"The target route."})
    private void setPath(String path) {
        this.path = path;
    }

    @CommandLine.Parameters(description={"The location on disk where the subtree should be stored."})
    private void setFileName(Path fileName) {
        this.fileName = this.pathMustNotExist(FileUtils.getAbsolutePath((Path)fileName));
    }

    @Override
    public void run() {
        try {
            MerkleNode subtree = this.getStateEditor().getRelativeNode(this.path);
            if (!Files.exists(this.fileName.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.fileName.getParent(), new FileAttribute[0]);
            }
            if (logger.isInfoEnabled(LogMarker.CLI.getMarker())) {
                logger.info(LogMarker.CLI.getMarker(), "Writing {} to {}", (Object)StateEditorUtils.formatNode(subtree), (Object)StateEditorUtils.formatFile(this.fileName));
            }
            MerkleDataOutputStream out = new MerkleDataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.fileName.toFile())));
            out.writeMerkleTree(this.fileName.getParent(), subtree);
            out.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

