/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.utils;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.streams.CallOperationType;
import com.hedera.hapi.streams.ContractAction;
import com.hedera.hapi.streams.ContractActionType;
import com.hedera.hapi.streams.codec.ContractActionProtoCodec;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.utils.ActionWrapper;
import com.hedera.node.app.service.contract.impl.exec.utils.ActionsHelper;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.exec.utils.InvalidAddressContext;
import com.hedera.node.app.service.contract.impl.state.HederaEvmAccount;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.contract.impl.utils.OpcodeUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.DelegatingBytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.code.CodeV0;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class ActionStack {
    private static final Logger log = LogManager.getLogger(ActionStack.class);
    private final ActionsHelper helper;
    private final List<ActionWrapper> allActions;
    private final Deque<ActionWrapper> actionsStack;
    private final List<ActionWrapper> invalidActions;

    public ActionStack() {
        this(new ActionsHelper(), new ArrayList<ActionWrapper>(), new ArrayDeque<ActionWrapper>(), new ArrayList<ActionWrapper>());
    }

    public ActionStack(@NonNull ActionsHelper helper, @NonNull List<ActionWrapper> allActions, @NonNull Deque<ActionWrapper> actionsStack, @NonNull List<ActionWrapper> invalidActions) {
        this.helper = helper;
        this.invalidActions = invalidActions;
        this.allActions = allActions;
        this.actionsStack = actionsStack;
    }

    @NonNull
    public List<ContractAction> asContractActions() {
        return this.allActions.stream().map(ActionWrapper::get).toList();
    }

    public void finalizeLastAction(@NonNull MessageFrame frame, @NonNull Validation validation) {
        this.internalFinalize(validation, frame);
    }

    public void finalizeLastStackActionAsPrecompile(@NonNull MessageFrame frame, @NonNull ContractActionType type, @NonNull Validation validation) {
        this.internalFinalize(validation, frame, action -> action.copyBuilder().recipientContract(FrameUtils.entityIdFactory(frame).newContractId(ConversionUtils.numberOfLongZero(frame.getContractAddress()))).callType(type).build());
    }

    private void internalFinalize(@NonNull Validation validateAction, @NonNull MessageFrame frame) {
        this.internalFinalize(validateAction, frame, null);
    }

    private void internalFinalize(@NonNull Validation validateAction, @NonNull MessageFrame frame, @Nullable UnaryOperator<ContractAction> transform) {
        Objects.requireNonNull(frame);
        if (this.actionsStack.isEmpty()) {
            log.warn("Action stack prematurely empty ({})", new Supplier[]{() -> ActionStack.formatFrameContextForLog(frame)});
            return;
        }
        ActionWrapper lastWrappedAction = this.actionsStack.pop();
        ContractAction finalAction = this.finalFormOf(lastWrappedAction.get(), frame);
        lastWrappedAction.set(transform == null ? finalAction : (ContractAction)transform.apply(finalAction));
        if (validateAction == Validation.ON && !this.helper.isValid(lastWrappedAction.get())) {
            this.invalidActions.add(lastWrappedAction);
        }
    }

    private ContractAction finalFormOf(@NonNull ContractAction action, @NonNull MessageFrame frame) {
        return switch (frame.getState()) {
            default -> throw new MatchException(null, null);
            case MessageFrame.State.NOT_STARTED, MessageFrame.State.CODE_EXECUTING, MessageFrame.State.CODE_SUSPENDED -> action;
            case MessageFrame.State.CODE_SUCCESS, MessageFrame.State.COMPLETED_SUCCESS -> {
                ContractAction.Builder builder = action.copyBuilder();
                builder.gasUsed(action.gas() - frame.getRemainingGas());
                if (action.callType() == ContractActionType.CREATE) {
                    builder.output(com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY);
                } else {
                    builder.output(ConversionUtils.tuweniToPbjBytes(frame.getOutputData()));
                    if (action.targetedAddress() != null) {
                        Address maybeCreatedAddress = ConversionUtils.pbjToBesuAddress(action.targetedAddressOrThrow());
                        HederaEvmAccount maybeCreatedAccount = FrameUtils.proxyUpdaterFor(frame).getHederaAccount(maybeCreatedAddress);
                        if (maybeCreatedAccount != null) {
                            builder.recipientAccount(maybeCreatedAccount.hederaId());
                        }
                    }
                }
                yield builder.build();
            }
            case MessageFrame.State.REVERT -> {
                ContractAction.Builder builder = action.copyBuilder();
                builder.gasUsed(action.gas() - frame.getRemainingGas());
                frame.getRevertReason().ifPresentOrElse(reason -> builder.revertReason(ConversionUtils.tuweniToPbjBytes(reason)), () -> builder.revertReason(com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY));
                yield this.withUnsetRecipientIfNeeded(frame.getType(), builder);
            }
            case MessageFrame.State.EXCEPTIONAL_HALT, MessageFrame.State.COMPLETED_FAILED -> {
                ContractAction.Builder builder = action.copyBuilder();
                builder.gasUsed(action.gas());
                Optional maybeHaltReason = frame.getExceptionalHaltReason();
                if (maybeHaltReason.isPresent()) {
                    InvalidAddressContext invalidAddressContext;
                    ExceptionalHaltReason haltReason = (ExceptionalHaltReason)maybeHaltReason.get();
                    builder.error(com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])haltReason.name().getBytes(StandardCharsets.UTF_8)));
                    if (ContractActionType.CALL.equals((Object)action.callType()) && haltReason == CustomExceptionalHaltReason.INVALID_SOLIDITY_ADDRESS && InvalidAddressContext.InvalidAddressType.InvalidCallTarget.equals((Object)(invalidAddressContext = FrameUtils.invalidAddressContext(frame)).type())) {
                        this.allActions.add(new ActionWrapper(this.helper.createSynthActionForMissingAddressIn(frame, invalidAddressContext.culpritAddress())));
                    }
                } else {
                    builder.error(com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY);
                }
                yield this.withUnsetRecipientIfNeeded(frame.getType(), builder);
            }
        };
    }

    public void pushActionOfTopLevel(@NonNull MessageFrame frame) {
        ContractAction.Builder builder = ContractAction.newBuilder().callOperationType(this.asCallOperationType(frame.getType())).callingAccount(this.accountIdWith(frame, ConversionUtils.hederaIdNumOfOriginatorIn(frame)));
        this.completePush(builder, frame);
    }

    public void pushActionOfIntermediate(@NonNull MessageFrame frame) {
        ContractAction.Builder builder = ContractAction.newBuilder().callOperationType(OpcodeUtils.asCallOperationType(frame.getCurrentOperation().getOpcode())).callingContract(this.contractIdWith(frame, ConversionUtils.hederaIdNumOfContractIn(frame)));
        this.completePush(builder, Objects.requireNonNull((MessageFrame)frame.getMessageFrameStack().peek()));
    }

    private void completePush(@NonNull ContractAction.Builder builder, @NonNull MessageFrame frame) {
        builder.callType(this.asActionType(frame.getType())).gas(frame.getRemainingGas()).input(ConversionUtils.tuweniToPbjBytes(frame.getInputData())).value(frame.getValue().toLong()).callDepth(frame.getDepth());
        if (this.targetsMissingAddress(frame)) {
            builder.targetedAddress(ConversionUtils.tuweniToPbjBytes((Bytes)frame.getContractAddress()));
        } else if (CodeV0.EMPTY_CODE.equals((Object)frame.getCode())) {
            builder.recipientAccount(this.accountIdWith(frame, ConversionUtils.hederaIdNumOfContractIn(frame)));
        } else {
            try {
                builder.recipientContract(this.contractIdWith(frame, ConversionUtils.hederaIdNumOfContractIn(frame)));
            }
            catch (NullPointerException ignore) {
                builder.targetedAddress(ConversionUtils.tuweniToPbjBytes((Bytes)frame.getContractAddress()));
            }
        }
        ActionWrapper wrappedAction = new ActionWrapper(builder.build());
        this.allActions.add(wrappedAction);
        this.actionsStack.push(wrappedAction);
    }

    public void sanitizeFinalActionsAndLogAnomalies(@NonNull MessageFrame frame, @NonNull Logger log, @NonNull Level level) {
        if (!this.actionsStack.isEmpty() || !this.invalidActions.isEmpty()) {
            String anomalies = this.formatAnomaliesAtFinalizationForLog();
            String frameContext = ActionStack.formatFrameContextForLog(frame);
            log.atLevel(level).log("Invalid at end of EVM run: {} ({})", (Object)anomalies, (Object)frameContext);
        }
        if (!this.invalidActions.isEmpty()) {
            this.allActions.removeAll(this.invalidActions);
            this.invalidActions.clear();
        }
    }

    private ContractActionType asActionType(MessageFrame.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case MessageFrame.Type.CONTRACT_CREATION -> ContractActionType.CREATE;
            case MessageFrame.Type.MESSAGE_CALL -> ContractActionType.CALL;
        };
    }

    private CallOperationType asCallOperationType(MessageFrame.Type type) {
        return type == MessageFrame.Type.CONTRACT_CREATION ? CallOperationType.OP_CREATE : CallOperationType.OP_CALL;
    }

    private boolean isMissing(@NonNull MessageFrame frame, @NonNull Address address) {
        return frame.getWorldUpdater().get(address) == null;
    }

    private AccountID accountIdWith(@NonNull MessageFrame frame, long num) {
        return FrameUtils.entityIdFactory(frame).newAccountId(num);
    }

    private ContractID contractIdWith(@NonNull MessageFrame frame, long num) {
        return FrameUtils.entityIdFactory(frame).newContractId(num);
    }

    private ContractAction withUnsetRecipientIfNeeded(@NonNull MessageFrame.Type type, @NonNull ContractAction.Builder builder) {
        ContractAction action = builder.build();
        return type == MessageFrame.Type.CONTRACT_CREATION ? this.withUnsetRecipient(action) : action;
    }

    private ContractAction withUnsetRecipient(@NonNull ContractAction action) {
        return new ContractAction(action.callType(), action.caller(), action.gas(), action.input(), ContractActionProtoCodec.RECIPIENT_UNSET, action.value(), action.gasUsed(), action.resultData(), action.callDepth(), action.callOperationType());
    }

    private boolean targetsMissingAddress(@NonNull MessageFrame frame) {
        return frame.getType() == MessageFrame.Type.MESSAGE_CALL && this.isMissing(frame, frame.getContractAddress());
    }

    private String formatAnomaliesAtFinalizationForLog() {
        ArrayList<String> msgs = new ArrayList<String>();
        if (!this.actionsStack.isEmpty()) {
            msgs.add("currentActionsStack not empty, has %d elements left".formatted(this.actionsStack.size()));
        }
        if (!this.invalidActions.isEmpty()) {
            msgs.add("of %d actions given, %d were invalid".formatted(this.allActions.size(), this.invalidActions.size()));
            for (ActionWrapper ia : this.invalidActions) {
                msgs.add("invalid: %s".formatted(this.helper.prettyPrint(ia.get())));
            }
        }
        return String.join((CharSequence)"; ", msgs);
    }

    private static String formatFrameContextForLog(@NonNull MessageFrame frame) {
        Function<Address, String> addressToString = DelegatingBytes::toUnprefixedHexString;
        String originator = ActionStack.get(frame, MessageFrame::getOriginatorAddress, addressToString);
        String sender = ActionStack.get(frame, MessageFrame::getSenderAddress, addressToString);
        String recipient = ActionStack.get(frame, MessageFrame::getRecipientAddress, addressToString);
        String contract = ActionStack.get(frame, MessageFrame::getContractAddress, addressToString);
        String type = ActionStack.get(frame, MessageFrame::getType, Object::toString);
        String state = ActionStack.get(frame, MessageFrame::getState, Object::toString);
        return "originator %s sender %s recipient %s contract %s type %s state %s".formatted(originator, sender, recipient, contract, type, state);
    }

    private static <E, I> String get(@NonNull E subject, Function<E, I> getter, Function<I, String> processor) {
        return processor.compose(getter).apply(subject);
    }

    public static enum Validation {
        ON,
        OFF;

    }
}

