/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb;

import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.FieldType;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.stream.ReadableStreamingData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkledb.KeyRange;
import com.swirlds.merkledb.MerkleDbCompactionCoordinator;
import com.swirlds.merkledb.MerkleDbPaths;
import com.swirlds.merkledb.MerkleDbStatisticsUpdater;
import com.swirlds.merkledb.collections.HashList;
import com.swirlds.merkledb.collections.HashListByteBuffer;
import com.swirlds.merkledb.collections.LongList;
import com.swirlds.merkledb.collections.LongListDisk;
import com.swirlds.merkledb.collections.LongListOffHeap;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.merkledb.files.DataFileCollection;
import com.swirlds.merkledb.files.DataFileCommon;
import com.swirlds.merkledb.files.DataFileCompactor;
import com.swirlds.merkledb.files.DataFileReader;
import com.swirlds.merkledb.files.MemoryIndexDiskKeyValueStore;
import com.swirlds.merkledb.files.hashmap.HalfDiskHashMap;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualHashRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class MerkleDbDataSource
implements VirtualDataSource {
    private static final Logger logger = LogManager.getLogger(MerkleDbDataSource.class);
    static final String MERKLEDB_COMPONENT = "merkledb";
    private static final LongAdder COUNT_OF_OPEN_DATABASES = new LongAdder();
    private static final FieldDefinition FIELD_DSMETADATA_MINVALIDKEY = new FieldDefinition("minValidKey", FieldType.UINT64, false, true, false, 1);
    private static final FieldDefinition FIELD_DSMETADATA_MAXVALIDKEY = new FieldDefinition("maxValidKey", FieldType.UINT64, false, true, false, 2);
    private static final FieldDefinition FIELD_DSMETADATA_INITIALCAPACITY = new FieldDefinition("initialCapacity", FieldType.UINT64, false, true, false, 3);
    private static final FieldDefinition FIELD_DSMETADATA_HASHESRAMTODISKTHRESHOLD = new FieldDefinition("hashesRamToDiskThreshold", FieldType.UINT64, false, true, false, 4);
    private final MerkleDbConfig merkleDbConfig;
    private final String tableName;
    private volatile long initialCapacity;
    private volatile long hashesRamToDiskThreshold;
    private final boolean preferDiskBasedIndices;
    private final LongList pathToDiskLocationInternalNodes;
    private final LongList pathToDiskLocationLeafNodes;
    private final HashListByteBuffer hashStoreRam;
    private final MemoryIndexDiskKeyValueStore hashStoreDisk;
    private final boolean hasDiskStoreForHashes;
    private final HalfDiskHashMap keyToPath;
    private final MemoryIndexDiskKeyValueStore pathToKeyValue;
    private final int leafRecordCacheSize;
    private final VirtualLeafBytes[] leafRecordCache;
    private final ExecutorService storeHashesExecutor;
    private final ExecutorService storeLeavesExecutor;
    private final ExecutorService storeLeafKeysExecutor;
    private final ExecutorService snapshotExecutor;
    private final AtomicBoolean snapshotInProgress = new AtomicBoolean(false);
    private volatile KeyRange validLeafPathRange = KeyRange.INVALID_KEY_RANGE;
    private final MerkleDbPaths dbPaths;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    final MerkleDbCompactionCoordinator compactionCoordinator;
    private MerkleDbStatisticsUpdater statisticsUpdater;

    public MerkleDbDataSource(Path storageDir, Configuration config, String tableName, boolean compactionEnabled, boolean offlineUse) throws IOException {
        this(storageDir, config, tableName, 0L, 0L, compactionEnabled, offlineUse);
    }

    public MerkleDbDataSource(Path storageDir, Configuration config, String tableName, long initialCapacity, long hashesRamToDiskThreshold, boolean compactionEnabled, boolean diskBasedIndices) throws IOException {
        String tablesToRepairHdhmConfig;
        DataFileCollection.LoadedDataCallback leafRecordLoadedCallback;
        boolean needRestorePathToDiskLocationLeafNodes;
        this.tableName = tableName;
        this.preferDiskBasedIndices = diskBasedIndices;
        this.merkleDbConfig = (MerkleDbConfig)config.getConfigData(MerkleDbConfig.class);
        ThreadGroup threadGroup = new ThreadGroup("MerkleDb-" + tableName);
        this.storeHashesExecutor = Executors.newSingleThreadExecutor(((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent(MERKLEDB_COMPONENT)).setThreadGroup(threadGroup)).setThreadName("Store hashes")).setExceptionHandler((t, ex) -> logger.error(LogMarker.EXCEPTION.getMarker(), "[{}] Uncaught exception during storing hashes", (Object)tableName, (Object)ex))).buildFactory());
        this.storeLeavesExecutor = Executors.newSingleThreadExecutor(((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent(MERKLEDB_COMPONENT)).setThreadGroup(threadGroup)).setThreadName("Store leaves")).setExceptionHandler((t, ex) -> logger.error(LogMarker.EXCEPTION.getMarker(), "[{}] Uncaught exception during storing leaves", (Object)tableName, (Object)ex))).buildFactory());
        this.storeLeafKeysExecutor = Executors.newSingleThreadExecutor(((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent(MERKLEDB_COMPONENT)).setThreadGroup(threadGroup)).setThreadName("Store leaf keys")).setExceptionHandler((t, ex) -> logger.error(LogMarker.EXCEPTION.getMarker(), "[{}] Uncaught exception during storing leaf keys", (Object)tableName, (Object)ex))).buildFactory());
        this.snapshotExecutor = Executors.newCachedThreadPool(((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent(MERKLEDB_COMPONENT)).setThreadGroup(threadGroup)).setThreadName("Snapshot")).setExceptionHandler((t, ex) -> logger.error(LogMarker.EXCEPTION.getMarker(), "Uncaught exception during snapshots", ex))).buildFactory());
        this.dbPaths = new MerkleDbPaths(storageDir);
        if (Files.exists(storageDir, new LinkOption[0])) {
            if (!this.loadMetadata(this.dbPaths)) {
                logger.error(LogMarker.MERKLE_DB.getMarker(), "[{}] Loading existing set of data files but no metadata file was found in [{}]", (Object)tableName, (Object)storageDir.toAbsolutePath());
                throw new IOException("Can not load an existing MerkleDbDataSource from [" + String.valueOf(storageDir.toAbsolutePath()) + "] because metadata file is missing");
            }
        } else {
            this.initialCapacity = initialCapacity;
            this.hashesRamToDiskThreshold = hashesRamToDiskThreshold;
            Files.createDirectories(storageDir, new FileAttribute[0]);
        }
        if (this.initialCapacity <= 0L) {
            throw new IllegalStateException("Initial capacity must be greater than 0, but was " + this.initialCapacity);
        }
        if (this.hashesRamToDiskThreshold < 0L) {
            throw new IllegalStateException("Hashes RAM/disk threshold must be greater than or equal to 0, but was " + this.hashesRamToDiskThreshold);
        }
        this.saveMetadata(this.dbPaths);
        long pathIndexCapacity = this.merkleDbConfig.maxNumOfKeys() * 2L;
        boolean forceIndexRebuilding = this.merkleDbConfig.indexRebuildingEnforced();
        Path pathToHashLocationFile = this.dbPaths.pathToDiskLocationInternalNodesFile;
        this.pathToDiskLocationInternalNodes = Files.exists(pathToHashLocationFile, new LinkOption[0]) && !forceIndexRebuilding ? (this.preferDiskBasedIndices ? new LongListDisk(pathToHashLocationFile, pathIndexCapacity, config) : new LongListOffHeap(pathToHashLocationFile, pathIndexCapacity, config)) : (this.preferDiskBasedIndices ? new LongListDisk(pathIndexCapacity, config) : new LongListOffHeap(pathIndexCapacity, config));
        Path pathToLeafLocationFile = this.dbPaths.pathToDiskLocationLeafNodesFile;
        if (Files.exists(pathToLeafLocationFile, new LinkOption[0]) && !forceIndexRebuilding) {
            this.pathToDiskLocationLeafNodes = this.preferDiskBasedIndices ? new LongListDisk(pathToLeafLocationFile, pathIndexCapacity, config) : new LongListOffHeap(pathToLeafLocationFile, pathIndexCapacity, config);
        } else {
            LongList longList = this.pathToDiskLocationLeafNodes = this.preferDiskBasedIndices ? new LongListDisk(pathIndexCapacity, config) : new LongListOffHeap(pathIndexCapacity, config);
        }
        this.hashStoreRam = this.hashesRamToDiskThreshold > 0L ? (Files.exists(this.dbPaths.hashStoreRamFile, new LinkOption[0]) ? new HashListByteBuffer(this.dbPaths.hashStoreRamFile, this.hashesRamToDiskThreshold, config) : new HashListByteBuffer(this.hashesRamToDiskThreshold, config)) : null;
        String hashStoreDiskStoreName = tableName + "_internalhashes";
        boolean bl = this.hasDiskStoreForHashes = this.hashesRamToDiskThreshold < Long.MAX_VALUE;
        if (this.hasDiskStoreForHashes) {
            DataFileCollection.LoadedDataCallback hashRecordLoadedCallback;
            boolean needRestorePathToDiskLocationInternalNodes;
            boolean bl2 = needRestorePathToDiskLocationInternalNodes = this.pathToDiskLocationInternalNodes.size() == 0L;
            if (needRestorePathToDiskLocationInternalNodes) {
                if (this.validLeafPathRange.getMaxValidKey() >= 0L) {
                    this.pathToDiskLocationInternalNodes.updateValidRange(0L, this.validLeafPathRange.getMaxValidKey());
                }
                hashRecordLoadedCallback = (dataLocation, hashData) -> {
                    VirtualHashRecord hashRecord = VirtualHashRecord.parseFrom((ReadableSequentialData)hashData);
                    long path = hashRecord.path();
                    if (path <= this.validLeafPathRange.getMaxValidKey()) {
                        this.pathToDiskLocationInternalNodes.put(path, dataLocation);
                    }
                };
            } else {
                hashRecordLoadedCallback = null;
            }
            this.hashStoreDisk = new MemoryIndexDiskKeyValueStore(this.merkleDbConfig, this.dbPaths.hashStoreDiskDirectory, hashStoreDiskStoreName, tableName + ":internalHashes", hashRecordLoadedCallback, this.pathToDiskLocationInternalNodes);
        } else {
            this.hashStoreDisk = null;
        }
        boolean bl3 = needRestorePathToDiskLocationLeafNodes = this.pathToDiskLocationLeafNodes.size() == 0L && this.validLeafPathRange.getMinValidKey() > 0L;
        if (needRestorePathToDiskLocationLeafNodes) {
            if (this.validLeafPathRange.getMaxValidKey() >= 0L) {
                this.pathToDiskLocationLeafNodes.updateValidRange(this.validLeafPathRange.getMinValidKey(), this.validLeafPathRange.getMaxValidKey());
            }
            leafRecordLoadedCallback = (dataLocation, leafData) -> {
                VirtualLeafBytes leafBytes = VirtualLeafBytes.parseFrom((ReadableSequentialData)leafData);
                long path = leafBytes.path();
                if (this.validLeafPathRange.withinRange(path)) {
                    this.pathToDiskLocationLeafNodes.put(path, dataLocation);
                }
            };
        } else {
            leafRecordLoadedCallback = null;
        }
        String pathToKeyValueStoreName = tableName + "_pathtohashkeyvalue";
        this.pathToKeyValue = new MemoryIndexDiskKeyValueStore(this.merkleDbConfig, this.dbPaths.pathToKeyValueDirectory, pathToKeyValueStoreName, tableName + ":pathToHashKeyValue", leafRecordLoadedCallback, this.pathToDiskLocationLeafNodes);
        String keyToPathStoreName = tableName + "_objectkeytopath";
        this.keyToPath = new HalfDiskHashMap(config, this.initialCapacity, this.dbPaths.keyToPathDirectory, keyToPathStoreName, tableName + ":objectKeyToPath", this.preferDiskBasedIndices);
        this.keyToPath.printStats();
        if (!this.preferDiskBasedIndices && (tablesToRepairHdhmConfig = this.merkleDbConfig.tablesToRepairHdhm()) != null) {
            String[] tableNames = tablesToRepairHdhmConfig.split(",");
            if (Arrays.stream(tableNames).filter(s -> !s.isBlank()).anyMatch(tableName::equals)) {
                this.keyToPath.repair(this.getFirstLeafPath(), this.getLastLeafPath(), this.pathToKeyValue);
            }
        }
        this.leafRecordCacheSize = this.merkleDbConfig.leafRecordCacheSize();
        this.leafRecordCache = this.leafRecordCacheSize > 0 ? new VirtualLeafBytes[this.leafRecordCacheSize] : null;
        this.statisticsUpdater = new MerkleDbStatisticsUpdater(this.merkleDbConfig, tableName);
        this.compactionCoordinator = new MerkleDbCompactionCoordinator(tableName, this.merkleDbConfig);
        if (compactionEnabled) {
            this.enableBackgroundCompaction();
        }
        COUNT_OF_OPEN_DATABASES.increment();
        logger.info(LogMarker.MERKLE_DB.getMarker(), "Created MerkleDB [{}] with store path '{}', initial capacity = {}, hash RAM/disk cutoff = {}", (Object)tableName, (Object)storageDir, (Object)this.initialCapacity, (Object)this.hashesRamToDiskThreshold);
    }

    public void enableBackgroundCompaction() {
        this.compactionCoordinator.enableBackgroundCompaction();
    }

    public void stopAndDisableBackgroundCompaction() {
        this.compactionCoordinator.stopAndDisableBackgroundCompaction();
    }

    public static long getCountOfOpenDatabases() {
        return COUNT_OF_OPEN_DATABASES.sum();
    }

    public long getFirstLeafPath() {
        return this.validLeafPathRange.getMinValidKey();
    }

    public long getLastLeafPath() {
        return this.validLeafPathRange.getMaxValidKey();
    }

    void pauseCompaction() throws IOException {
        this.compactionCoordinator.pauseCompaction();
    }

    void resumeCompaction() throws IOException {
        this.compactionCoordinator.resumeCompaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRecords(long firstLeafPath, long lastLeafPath, @NonNull Stream<VirtualHashRecord> hashRecordsToUpdate, @NonNull Stream<VirtualLeafBytes> leafRecordsToAddOrUpdate, @NonNull Stream<VirtualLeafBytes> leafRecordsToDelete, boolean isReconnectContext) throws IOException {
        try {
            this.validLeafPathRange = new KeyRange(firstLeafPath, lastLeafPath);
            CountDownLatch countDownLatch = new CountDownLatch(lastLeafPath > 0L ? 3 : 2);
            if (lastLeafPath > 0L) {
                this.storeHashesExecutor.execute(() -> {
                    try {
                        this.writeHashes(lastLeafPath, hashRecordsToUpdate);
                    }
                    catch (IOException e) {
                        logger.error(LogMarker.EXCEPTION.getMarker(), "[{}] Failed to store hashes", (Object)this.tableName, (Object)e);
                        throw new UncheckedIOException(e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
            List<VirtualLeafBytes> sortedDirtyLeaves = ((Stream)leafRecordsToAddOrUpdate.parallel()).sorted(Comparator.comparingLong(VirtualLeafBytes::path)).toList();
            List<VirtualLeafBytes> deletedLeaves = leafRecordsToDelete.toList();
            this.storeLeavesExecutor.execute(() -> {
                try {
                    this.writeLeavesToPathToKeyValue(firstLeafPath, lastLeafPath, sortedDirtyLeaves);
                }
                catch (IOException e) {
                    logger.error(LogMarker.EXCEPTION.getMarker(), "[{}] Failed to store leaves", (Object)this.tableName, (Object)e);
                    throw new UncheckedIOException(e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
            this.storeLeafKeysExecutor.execute(() -> {
                try {
                    this.writeLeavesToKeyToPath(firstLeafPath, lastLeafPath, sortedDirtyLeaves, deletedLeaves, isReconnectContext);
                }
                catch (IOException e) {
                    logger.error(LogMarker.EXCEPTION.getMarker(), "[{}] Failed to store leaf keys", (Object)this.tableName, (Object)e);
                    throw new UncheckedIOException(e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                logger.warn(LogMarker.EXCEPTION.getMarker(), "[{}] Interrupted while waiting on internal record storage", (Object)this.tableName, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.statisticsUpdater.updateStoreFileStats(this);
            this.statisticsUpdater.updateOffHeapStats(this);
        }
    }

    @Nullable
    public VirtualLeafBytes<?> loadLeafRecord(Bytes keyBytes) throws IOException {
        long path;
        Objects.requireNonNull(keyBytes);
        int keyHashCode = keyBytes.hashCode();
        VirtualLeafBytes cached = null;
        int cacheIndex = -1;
        if (this.leafRecordCache != null) {
            cacheIndex = Math.abs(keyHashCode % this.leafRecordCacheSize);
            cached = this.leafRecordCache[cacheIndex];
        }
        if (cached != null && keyBytes.equals((Object)cached.keyBytes())) {
            if (cached.valueBytes() != null) {
                return cached;
            }
            path = cached.path();
        } else {
            cached = null;
            this.statisticsUpdater.countLeafKeyReads();
            path = this.keyToPath.get(keyBytes, -1L);
        }
        if (path == -1L) {
            if (this.leafRecordCache != null && cached == null) {
                this.leafRecordCache[cacheIndex] = new VirtualLeafBytes(path, keyBytes, null);
            }
            return null;
        }
        if (!this.validLeafPathRange.withinRange(path)) {
            return null;
        }
        this.statisticsUpdater.countLeafReads();
        VirtualLeafBytes leafBytes = VirtualLeafBytes.parseFrom((ReadableSequentialData)this.pathToKeyValue.get(path));
        assert (leafBytes != null && leafBytes.keyBytes().equals((Object)keyBytes));
        if (this.leafRecordCache != null) {
            this.leafRecordCache[cacheIndex] = leafBytes;
        }
        return leafBytes;
    }

    @Nullable
    public VirtualLeafBytes<?> loadLeafRecord(long path) throws IOException {
        if (path < 0L) {
            throw new IllegalArgumentException("Path (" + path + ") is not valid");
        }
        KeyRange leafPathRange = this.validLeafPathRange;
        if (!leafPathRange.withinRange(path)) {
            return null;
        }
        this.statisticsUpdater.countLeafReads();
        return VirtualLeafBytes.parseFrom((ReadableSequentialData)this.pathToKeyValue.get(path));
    }

    public long findKey(Bytes keyBytes) throws IOException {
        VirtualLeafBytes cached;
        Objects.requireNonNull(keyBytes);
        int keyHashCode = keyBytes.hashCode();
        int cacheIndex = -1;
        if (this.leafRecordCache != null && (cached = this.leafRecordCache[cacheIndex = Math.abs(keyHashCode % this.leafRecordCacheSize)]) != null && keyBytes.equals((Object)cached.keyBytes())) {
            return cached.path();
        }
        this.statisticsUpdater.countLeafKeyReads();
        long path = this.keyToPath.get(keyBytes, -1L);
        if (this.leafRecordCache != null) {
            this.leafRecordCache[cacheIndex] = new VirtualLeafBytes(path, keyBytes, null);
        }
        return path;
    }

    @Nullable
    public Hash loadHash(long path) throws IOException {
        Hash hash;
        if (path < 0L) {
            throw new IllegalArgumentException("Path (" + path + ") is not valid");
        }
        long lastLeaf = this.validLeafPathRange.getMaxValidKey();
        if (path > lastLeaf) {
            return null;
        }
        if (path < this.hashesRamToDiskThreshold) {
            hash = this.hashStoreRam.get(path);
        } else {
            VirtualHashRecord rec = VirtualHashRecord.parseFrom((ReadableSequentialData)this.hashStoreDisk.get(path));
            hash = rec != null ? rec.hash() : null;
            this.statisticsUpdater.countHashReads();
        }
        return hash;
    }

    public boolean loadAndWriteHash(long path, SerializableDataOutputStream out) throws IOException {
        if (path < 0L) {
            throw new IllegalArgumentException("path is less than 0");
        }
        long lastLeaf = this.validLeafPathRange.getMaxValidKey();
        if (path > lastLeaf) {
            return false;
        }
        if (path < this.hashesRamToDiskThreshold) {
            Hash hash = this.hashStoreRam.get(path);
            if (hash == null) {
                return false;
            }
            hash.serialize(out);
        } else {
            BufferedData hashBytes = this.hashStoreDisk.get(path);
            if (hashBytes == null) {
                return false;
            }
            VirtualHashRecord.extractAndWriteHashBytes((ReadableSequentialData)hashBytes, (SerializableDataOutputStream)out);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean keepData) throws IOException {
        if (!this.closed.getAndSet(true)) {
            try {
                this.compactionCoordinator.stopAndDisableBackgroundCompaction();
                this.shutdownThreadsAndWait(this.storeHashesExecutor, this.storeLeavesExecutor, this.storeLeafKeysExecutor, this.snapshotExecutor);
            }
            finally {
                try {
                    logger.info(LogMarker.MERKLE_DB.getMarker(), "Closing Data Source [{}]", (Object)this.tableName);
                    if (this.hashStoreRam != null) {
                        this.hashStoreRam.close();
                    }
                    if (this.hashStoreDisk != null) {
                        this.hashStoreDisk.close();
                    }
                    this.pathToDiskLocationInternalNodes.close();
                    this.keyToPath.close();
                    this.pathToKeyValue.close();
                    this.pathToDiskLocationLeafNodes.close();
                }
                catch (Exception e) {
                    logger.warn(LogMarker.EXCEPTION.getMarker(), "Exception while closing Data Source [{}]", (Object)this.tableName);
                }
                catch (Error t) {
                    logger.error(LogMarker.EXCEPTION.getMarker(), "Error while closing Data Source [{}]", (Object)this.tableName);
                    throw t;
                }
                finally {
                    COUNT_OF_OPEN_DATABASES.decrement();
                    if (!keepData) {
                        DataFileCommon.deleteDirectoryAndContents(this.dbPaths.storageDir);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshot(Path snapshotDirectory) throws IOException, IllegalStateException {
        boolean aSnapshotWasInProgress = this.snapshotInProgress.getAndSet(true);
        if (aSnapshotWasInProgress) {
            throw new IllegalStateException("Tried to start a snapshot when one was already in progress");
        }
        logger.info(LogMarker.MERKLE_DB.getMarker(), "[{}] Starting snapshot to {}", (Object)this.tableName, (Object)snapshotDirectory);
        try {
            long START = System.currentTimeMillis();
            Files.createDirectories(snapshotDirectory, new FileAttribute[0]);
            MerkleDbPaths snapshotDbPaths = new MerkleDbPaths(snapshotDirectory);
            try {
                CountDownLatch countDownLatch = new CountDownLatch(7);
                this.runWithSnapshotExecutor(true, countDownLatch, "pathToDiskLocationInternalNodes", () -> {
                    this.pathToDiskLocationInternalNodes.writeToFile(snapshotDbPaths.pathToDiskLocationInternalNodesFile);
                    return true;
                });
                this.runWithSnapshotExecutor(true, countDownLatch, "pathToDiskLocationLeafNodes", () -> {
                    this.pathToDiskLocationLeafNodes.writeToFile(snapshotDbPaths.pathToDiskLocationLeafNodesFile);
                    return true;
                });
                this.runWithSnapshotExecutor(this.hashStoreRam != null, countDownLatch, "internalHashStoreRam", () -> {
                    this.hashStoreRam.writeToFile(snapshotDbPaths.hashStoreRamFile);
                    return true;
                });
                this.runWithSnapshotExecutor(this.hashStoreDisk != null, countDownLatch, "internalHashStoreDisk", () -> {
                    this.hashStoreDisk.snapshot(snapshotDbPaths.hashStoreDiskDirectory);
                    return true;
                });
                this.runWithSnapshotExecutor(this.keyToPath != null, countDownLatch, "keyToPath", () -> {
                    this.keyToPath.snapshot(snapshotDbPaths.keyToPathDirectory);
                    return true;
                });
                this.runWithSnapshotExecutor(true, countDownLatch, "pathToKeyValue", () -> {
                    this.pathToKeyValue.snapshot(snapshotDbPaths.pathToKeyValueDirectory);
                    return true;
                });
                this.runWithSnapshotExecutor(true, countDownLatch, "metadata", () -> {
                    this.saveMetadata(snapshotDbPaths);
                    return true;
                });
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "[{}] InterruptedException from waiting for countDownLatch in snapshot", (Object)this.tableName, (Object)e);
                Thread.currentThread().interrupt();
            }
            logger.info(LogMarker.MERKLE_DB.getMarker(), "[{}] Snapshot all finished in {} seconds", (Object)this.tableName, (Object)((double)(System.currentTimeMillis() - START) * 0.001));
        }
        finally {
            this.snapshotInProgress.set(false);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("initialCapacity", (Object)this.initialCapacity).append("preferDiskBasedIndexes", (Object)this.preferDiskBasedIndices).append("pathToDiskLocationInternalNodes.size", (Object)this.pathToDiskLocationInternalNodes.size()).append("pathToDiskLocationLeafNodes.size", (Object)this.pathToDiskLocationLeafNodes.size()).append("hashesRamToDiskThreshold", (Object)this.hashesRamToDiskThreshold).append("hashStoreRam.size", this.hashStoreRam == null ? null : Long.valueOf(this.hashStoreRam.size())).append("hashStoreDisk", (Object)this.hashStoreDisk).append("hasDiskStoreForHashes", (Object)this.hasDiskStoreForHashes).append("keyToPath", (Object)this.keyToPath).append("pathToKeyValue", (Object)this.pathToKeyValue).append("snapshotInProgress", (Object)this.snapshotInProgress.get()).toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getInitialCapacity() {
        return this.initialCapacity;
    }

    public long getHashesRamToDiskThreshold() {
        return this.hashesRamToDiskThreshold;
    }

    boolean isCompactionEnabled() {
        return this.compactionCoordinator.isCompactionEnabled();
    }

    private void saveMetadata(MerkleDbPaths targetDir) throws IOException {
        KeyRange leafRange = this.validLeafPathRange;
        Path targetFile = targetDir.metadataFile;
        try (OutputStream fileOut = Files.newOutputStream(targetFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            WritableStreamingData out = new WritableStreamingData(fileOut);
            if (leafRange.getMinValidKey() != 0L) {
                ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_DSMETADATA_MINVALIDKEY);
                out.writeVarLong(leafRange.getMinValidKey(), false);
            }
            if (leafRange.getMaxValidKey() != 0L) {
                ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_DSMETADATA_MAXVALIDKEY);
                out.writeVarLong(leafRange.getMaxValidKey(), false);
            }
            ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_DSMETADATA_INITIALCAPACITY);
            out.writeVarLong(this.initialCapacity, false);
            if (this.hashesRamToDiskThreshold != 0L) {
                ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_DSMETADATA_HASHESRAMTODISKTHRESHOLD);
                out.writeVarLong(this.hashesRamToDiskThreshold, false);
            }
            fileOut.flush();
        }
    }

    private boolean loadMetadata(MerkleDbPaths sourceDir) throws IOException {
        if (Files.exists(sourceDir.metadataFile, new LinkOption[0])) {
            Path sourceFile = sourceDir.metadataFile;
            long minValidKey = 0L;
            long maxValidKey = 0L;
            try (ReadableStreamingData in = new ReadableStreamingData(sourceFile);){
                while (in.hasRemaining()) {
                    int tag = in.readVarInt(false);
                    int fieldNum = tag >> 3;
                    if (fieldNum == FIELD_DSMETADATA_MINVALIDKEY.number()) {
                        minValidKey = in.readVarLong(false);
                        continue;
                    }
                    if (fieldNum == FIELD_DSMETADATA_MAXVALIDKEY.number()) {
                        maxValidKey = in.readVarLong(false);
                        continue;
                    }
                    if (fieldNum == FIELD_DSMETADATA_INITIALCAPACITY.number()) {
                        this.initialCapacity = in.readVarLong(false);
                        continue;
                    }
                    if (fieldNum == FIELD_DSMETADATA_HASHESRAMTODISKTHRESHOLD.number()) {
                        this.hashesRamToDiskThreshold = in.readVarLong(false);
                        continue;
                    }
                    throw new IOException("Unknown data source metadata field: " + fieldNum);
                }
                this.validLeafPathRange = new KeyRange(minValidKey, maxValidKey);
            }
            Files.delete(sourceFile);
            return true;
        }
        return false;
    }

    public void registerMetrics(Metrics metrics) {
        this.statisticsUpdater.registerMetrics(metrics);
    }

    public void copyStatisticsFrom(VirtualDataSource that) {
        if (!(that instanceof MerkleDbDataSource)) {
            logger.warn(LogMarker.MERKLE_DB.getMarker(), "Can only copy statistics from MerkleDbDataSource");
            return;
        }
        MerkleDbDataSource thatDataSource = (MerkleDbDataSource)that;
        this.statisticsUpdater = thatDataSource.statisticsUpdater;
    }

    private void shutdownThreadsAndWait(ExecutorService ... executors) throws IOException {
        try {
            for (ExecutorService executor : executors) {
                if (executor.isShutdown()) continue;
                executor.shutdown();
                boolean finishedWithoutTimeout = executor.awaitTermination(5L, TimeUnit.MINUTES);
                if (finishedWithoutTimeout) continue;
                throw new IOException("Timeout while waiting for executor service to finish.");
            }
        }
        catch (InterruptedException e) {
            logger.warn(LogMarker.EXCEPTION.getMarker(), "[{}] Interrupted while waiting on executors to shutdown", (Object)this.tableName, (Object)e);
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for shutdown to finish.", e);
        }
    }

    private void runWithSnapshotExecutor(boolean shouldRun, CountDownLatch countDownLatch, String taskName, Callable<Object> runnable) {
        if (shouldRun) {
            this.snapshotExecutor.submit(() -> {
                long START = System.currentTimeMillis();
                try {
                    runnable.call();
                    logger.trace(LogMarker.MERKLE_DB.getMarker(), "[{}] Snapshot {} complete in {} seconds", (Object)this.tableName, (Object)taskName, (Object)((double)(System.currentTimeMillis() - START) * 0.001));
                    Boolean bl = true;
                    return bl;
                }
                catch (Throwable t) {
                    logger.error(LogMarker.EXCEPTION.getMarker(), "[{}] Snapshot {} failed", (Object)this.tableName, (Object)taskName, (Object)t);
                    throw t;
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        } else {
            countDownLatch.countDown();
        }
    }

    private void writeHashes(long maxValidPath, @NonNull Stream<VirtualHashRecord> dirtyHashes) throws IOException {
        if (this.hasDiskStoreForHashes) {
            if (maxValidPath < 0L) {
                this.hashStoreDisk.updateValidKeyRange(-1L, -1L);
            } else {
                this.hashStoreDisk.updateValidKeyRange(0L, maxValidPath);
            }
        }
        if (maxValidPath < 0L) {
            return;
        }
        if (this.hasDiskStoreForHashes) {
            this.hashStoreDisk.startWriting();
        }
        dirtyHashes.forEach(rec -> {
            this.statisticsUpdater.countFlushHashesWritten();
            if (rec.path() < this.hashesRamToDiskThreshold) {
                this.hashStoreRam.put(rec.path(), rec.hash());
            } else {
                try {
                    this.hashStoreDisk.put(rec.path(), arg_0 -> ((VirtualHashRecord)rec).writeTo(arg_0), rec.getSizeInBytes());
                }
                catch (IOException e) {
                    logger.error(LogMarker.EXCEPTION.getMarker(), "[{}] IOException writing internal records", (Object)this.tableName, (Object)e);
                    throw new UncheckedIOException(e);
                }
            }
        });
        if (this.hasDiskStoreForHashes) {
            DataFileReader newHashesFile = this.hashStoreDisk.endWriting();
            this.statisticsUpdater.setFlushHashesStoreFileSize(newHashesFile);
            this.runHashStoreCompaction();
        }
    }

    private void writeLeavesToPathToKeyValue(long firstLeafPath, long lastLeafPath, @NonNull List<VirtualLeafBytes> sortedDirtyLeaves) throws IOException {
        if (lastLeafPath < 0L) {
            this.pathToKeyValue.updateValidKeyRange(-1L, -1L);
        } else {
            this.pathToKeyValue.updateValidKeyRange(firstLeafPath, lastLeafPath);
        }
        if (sortedDirtyLeaves.isEmpty()) {
            return;
        }
        this.pathToKeyValue.startWriting();
        for (VirtualLeafBytes leafBytes : sortedDirtyLeaves) {
            try {
                this.pathToKeyValue.put(leafBytes.path(), arg_0 -> ((VirtualLeafBytes)leafBytes).writeTo(arg_0), leafBytes.getSizeInBytes());
            }
            catch (IOException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "[{}] IOException writing to pathToKeyValue", (Object)this.tableName, (Object)e);
                throw new UncheckedIOException(e);
            }
            this.statisticsUpdater.countFlushLeavesWritten();
        }
        DataFileReader pathToKeyValueReader = this.pathToKeyValue.endWriting();
        this.statisticsUpdater.setFlushLeavesStoreFileSize(pathToKeyValueReader);
        this.runPathToKeyStoreCompaction();
    }

    private void writeLeavesToKeyToPath(long firstLeafPath, long lastLeafPath, @NonNull List<VirtualLeafBytes> sortedDirtyLeaves, @NonNull List<VirtualLeafBytes> deletedLeaves, boolean isReconnect) throws IOException {
        long path;
        if (sortedDirtyLeaves.isEmpty() && deletedLeaves.isEmpty()) {
            return;
        }
        this.keyToPath.startWriting();
        for (VirtualLeafBytes leafBytes : sortedDirtyLeaves) {
            path = leafBytes.path();
            this.keyToPath.put(leafBytes.keyBytes(), path);
            this.statisticsUpdater.countFlushLeafKeysWritten();
            this.invalidateReadCache(leafBytes.keyBytes());
        }
        for (VirtualLeafBytes leafBytes : deletedLeaves) {
            path = leafBytes.path();
            if (isReconnect) {
                this.keyToPath.deleteIfEqual(leafBytes.keyBytes(), path);
            } else {
                this.keyToPath.delete(leafBytes.keyBytes());
            }
            this.statisticsUpdater.countFlushLeavesDeleted();
            this.invalidateReadCache(leafBytes.keyBytes());
        }
        DataFileReader keyToPathReader = this.keyToPath.endWriting();
        this.statisticsUpdater.setFlushLeafKeysStoreFileSize(keyToPathReader);
        if (!this.compactionCoordinator.isCompactionRunning("ObjectKeyToPath")) {
            this.keyToPath.resizeIfNeeded(firstLeafPath, lastLeafPath);
        }
        this.runKeyToPathStoreCompaction();
    }

    DataFileCompactor newHashStoreDiskCompactor() {
        return new DataFileCompactor(this.merkleDbConfig, this.tableName + "_HashStoreDisk", this.hashStoreDisk.getFileCollection(), this.pathToDiskLocationInternalNodes, this.statisticsUpdater::setHashesStoreCompactionTimeMs, this.statisticsUpdater::setHashesStoreCompactionSavedSpaceMb, this.statisticsUpdater::setHashesStoreFileSizeByLevelMb, () -> {
            this.statisticsUpdater.updateStoreFileStats(this);
            this.statisticsUpdater.updateOffHeapStats(this);
        });
    }

    DataFileCompactor newPathToKeyValueCompactor() {
        return new DataFileCompactor(this.merkleDbConfig, this.tableName + "_PathToKeyValue", this.pathToKeyValue.getFileCollection(), this.pathToDiskLocationLeafNodes, this.statisticsUpdater::setLeavesStoreCompactionTimeMs, this.statisticsUpdater::setLeavesStoreCompactionSavedSpaceMb, this.statisticsUpdater::setLeavesStoreFileSizeByLevelMb, () -> {
            this.statisticsUpdater.updateStoreFileStats(this);
            this.statisticsUpdater.updateOffHeapStats(this);
        });
    }

    DataFileCompactor newKeyToPathCompactor() {
        return new DataFileCompactor(this.merkleDbConfig, this.tableName + "_ObjectKeyToPath", this.keyToPath.getFileCollection(), this.keyToPath.getBucketIndexToBucketLocation(), this.statisticsUpdater::setLeafKeysStoreCompactionTimeMs, this.statisticsUpdater::setLeafKeysStoreCompactionSavedSpaceMb, this.statisticsUpdater::setLeafKeysStoreFileSizeByLevelMb, () -> {
            this.statisticsUpdater.updateStoreFileStats(this);
            this.statisticsUpdater.updateOffHeapStats(this);
        });
    }

    private void invalidateReadCache(Bytes keyBytes) {
        if (this.leafRecordCache == null) {
            return;
        }
        int keyHashCode = keyBytes.hashCode();
        int cacheIndex = Math.abs(keyHashCode % this.leafRecordCacheSize);
        VirtualLeafBytes cached = this.leafRecordCache[cacheIndex];
        if (cached != null && keyBytes.equals((Object)cached.keyBytes())) {
            this.leafRecordCache[cacheIndex] = null;
        }
    }

    public void runHashStoreCompaction() {
        this.compactionCoordinator.compactIfNotRunningYet("HashStoreDisk", this.newHashStoreDiskCompactor());
    }

    public void runPathToKeyStoreCompaction() {
        this.compactionCoordinator.compactIfNotRunningYet("PathToKeyValue", this.newPathToKeyValueCompactor());
    }

    public void runKeyToPathStoreCompaction() {
        this.compactionCoordinator.compactIfNotRunningYet("ObjectKeyToPath", this.newKeyToPathCompactor());
    }

    public void awaitForCurrentCompactionsToComplete(long timeoutMillis) {
        this.compactionCoordinator.awaitForCurrentCompactionsToComplete(timeoutMillis);
    }

    public MemoryIndexDiskKeyValueStore getHashStoreDisk() {
        return this.hashStoreDisk;
    }

    public HalfDiskHashMap getKeyToPath() {
        return this.keyToPath;
    }

    public MemoryIndexDiskKeyValueStore getPathToKeyValue() {
        return this.pathToKeyValue;
    }

    MerkleDbCompactionCoordinator getCompactionCoordinator() {
        return this.compactionCoordinator;
    }

    public HashList getHashStoreRam() {
        return this.hashStoreRam;
    }

    public LongList getPathToDiskLocationInternalNodes() {
        return this.pathToDiskLocationInternalNodes;
    }

    public LongList getPathToDiskLocationLeafNodes() {
        return this.pathToDiskLocationLeafNodes;
    }

    public int hashCode() {
        return Objects.hash(this.dbPaths.storageDir);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MerkleDbDataSource)) {
            return false;
        }
        MerkleDbDataSource other = (MerkleDbDataSource)o;
        return Objects.equals(this.dbPaths.storageDir, other.dbPaths.storageDir);
    }
}

