/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.workflows;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.entityid.EntityNumGenerator;
import com.hedera.node.app.spi.authorization.SystemPrivilege;
import com.hedera.node.app.spi.fees.ExchangeRateInfo;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.fees.ResourcePriceCalculator;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.spi.key.KeyVerifier;
import com.hedera.node.app.spi.records.BlockRecordInfo;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.throttle.ThrottleAdviser;
import com.hedera.node.app.spi.validation.AttributeValidator;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.ComputeDispatchFeesAsTopLevel;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.TransactionKeys;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public interface HandleContext {
    @NonNull
    public Instant consensusNow();

    @NonNull
    public TransactionBody body();

    @NonNull
    public AccountID payer();

    default public boolean tryToChargePayer(long amount) {
        return this.tryToCharge(this.payer(), amount);
    }

    public boolean tryToCharge(AccountID var1, long var2);

    public void refundBestEffort(AccountID var1, long var2);

    public void refundServiceFee(@NonNull AccountID var1, long var2);

    @NonNull
    public Configuration configuration();

    @NonNull
    public BlockRecordInfo blockRecordInfo();

    @NonNull
    public ResourcePriceCalculator resourcePriceCalculator();

    @NonNull
    public ExchangeRateInfo exchangeRateInfo();

    public EntityNumGenerator entityNumGenerator();

    @NonNull
    public AttributeValidator attributeValidator();

    @NonNull
    public ExpiryValidator expiryValidator();

    @NonNull
    public TransactionKeys allKeysForTransaction(@NonNull TransactionBody var1, @NonNull AccountID var2) throws PreCheckException;

    @NonNull
    public KeyVerifier keyVerifier();

    public SystemPrivilege hasPrivilegedAuthorization();

    @NonNull
    public StoreFactory storeFactory();

    @NonNull
    public NetworkInfo networkInfo();

    public Fees dispatchComputeFees(@NonNull TransactionBody var1, @NonNull AccountID var2, @NonNull ComputeDispatchFeesAsTopLevel var3);

    public <T extends StreamBuilder> T dispatch(@NonNull DispatchOptions<T> var1);

    @NonNull
    public SavepointStack savepointStack();

    @NonNull
    public ThrottleAdviser throttleAdviser();

    @NonNull
    public Map<AccountID, Long> dispatchPaidRewards();

    public NodeInfo creatorInfo();

    public DispatchMetadata dispatchMetadata();

    public long getGasPriceInTinycents();

    public static enum ConsensusThrottling {
        ON,
        OFF;

    }

    public static interface SavepointStack {
        public void createSavepoint();

        public void commit();

        public void rollback();

        public int depth();

        @NonNull
        public <T extends StreamBuilder> T getBaseBuilder(@NonNull Class<T> var1);

        @NonNull
        public <T> T addChildRecordBuilder(@NonNull Class<T> var1, @NonNull HederaFunctionality var2);

        @NonNull
        public <T> T addRemovableChildRecordBuilder(@NonNull Class<T> var1, @NonNull HederaFunctionality var2);
    }

    public static class DispatchMetadata {
        public static final DispatchMetadata EMPTY_METADATA = new DispatchMetadata(Map.of());
        private final Map<Type, Object> metadata;

        public DispatchMetadata(@NonNull Map<Type, Object> metadata) {
            this.metadata = Objects.requireNonNull(metadata);
        }

        public DispatchMetadata(@NonNull Type type, @NonNull Object value) {
            this.metadata = new HashMap<Type, Object>(Map.of(type, value));
        }

        public void putMetadata(@NonNull Type type, @NonNull Object value) {
            this.metadata.put(type, value);
        }

        @Nullable
        public <T> T getMetadataIfPresent(@NonNull Type type, @NonNull Class<T> javaType) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(javaType);
            Object v = this.metadata.get((Object)type);
            if (v == null) {
                return null;
            }
            return javaType.cast(v);
        }

        public <T> Optional<T> getMetadata(@NonNull Type type, @NonNull Class<T> javaType) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(javaType);
            return Optional.ofNullable(this.metadata.get((Object)type)).map(javaType::cast);
        }

        public static enum Type {
            TRANSACTION_FIXED_FEE,
            CUSTOM_FEE_CHARGING,
            EXPLICIT_WRITE_TRACING,
            INNER_TRANSACTION_BYTES,
            ETHEREUM_NONCE_INCREMENT_CALLBACK;

        }
    }

    public static enum PrecedingTransactionCategory {
        UNLIMITED_CHILD_RECORDS,
        LIMITED_CHILD_RECORDS;

    }

    public static enum TransactionCategory {
        USER,
        PRECEDING,
        CHILD,
        SCHEDULED,
        NODE,
        BATCH_INNER;

    }
}

