/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl;

import com.hedera.node.app.records.impl.BlockRecordInfoUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.hiero.base.crypto.DigestType;

public class BlockImplUtils {
    private BlockImplUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static Bytes appendHash(@NonNull Bytes hash, @NonNull Bytes hashes, int maxHashes) {
        byte[] newBytes;
        int limit = BlockRecordInfoUtils.HASH_SIZE * maxHashes;
        byte[] bytes = hashes.toByteArray();
        if (bytes.length < limit) {
            newBytes = new byte[bytes.length + BlockRecordInfoUtils.HASH_SIZE];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            hash.getBytes(0L, newBytes, newBytes.length - BlockRecordInfoUtils.HASH_SIZE, BlockRecordInfoUtils.HASH_SIZE);
        } else {
            newBytes = bytes;
            System.arraycopy(newBytes, BlockRecordInfoUtils.HASH_SIZE, newBytes, 0, newBytes.length - BlockRecordInfoUtils.HASH_SIZE);
            hash.getBytes(0L, newBytes, newBytes.length - BlockRecordInfoUtils.HASH_SIZE, BlockRecordInfoUtils.HASH_SIZE);
        }
        return Bytes.wrap((byte[])newBytes);
    }

    public static Bytes combine(@NonNull Bytes leftHash, @NonNull Bytes rightHash) {
        return Bytes.wrap((byte[])BlockImplUtils.combine(leftHash.toByteArray(), rightHash.toByteArray()));
    }

    public static byte[] combine(byte[] leftHash, byte[] rightHash) {
        try {
            MessageDigest digest = MessageDigest.getInstance(DigestType.SHA_384.algorithmName());
            digest.update(leftHash);
            digest.update(rightHash);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException fatal) {
            throw new IllegalStateException(fatal);
        }
    }
}

