/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.SignaturePair;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.hapi.util.UnknownHederaFunctionality;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.spi.validation.PreCheckValidator;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.prehandle.DueDiligenceException;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.GovernanceTransactionsConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.JumboTransactionsConfig;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class TransactionChecker {
    private static final Logger logger = LogManager.getLogger(TransactionChecker.class);
    private static final int USER_TRANSACTION_NONCE = 0;
    private static final List<HederaFunctionality> NON_JUMBO_TRANSACTIONS_BIGGER_THAN_6_KB = List.of(HederaFunctionality.CRS_PUBLICATION, HederaFunctionality.HISTORY_PROOF_VOTE);
    private static final String COUNTER_DEPRECATED_TXNS_NAME = "DeprTxnsRcv";
    private static final String COUNTER_RECEIVED_DEPRECATED_DESC = "number of deprecated txns (bodyBytes, sigMap) received";
    private static final String COUNTER_SUPER_DEPRECATED_TXNS_NAME = "SuperDeprTxnsRcv";
    private static final String COUNTER_RECEIVED_SUPER_DEPRECATED_DESC = "number of super-deprecated txns (body, sigs) received";
    private static final String COUNTER_NON_GOVERNANCE_OVERSIZED_TXNS = "NonGovernanceOversizedTxnsRcv";
    private static final String NON_GOVERNANCE_OVERSIZED_TXNS_DESC = "number of oversized txns received from a non-governance payer";
    private final Counter deprecatedCounter;
    private final Counter superDeprecatedCounter;
    private final Counter nonGovernanceOversizedTransactionsCounter;
    private final ConfigProvider configProvider;

    @Inject
    public TransactionChecker(@NonNull ConfigProvider configProvider, @NonNull Metrics metrics) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        this.configProvider = Objects.requireNonNull(configProvider, "configProvider must not be null");
        this.deprecatedCounter = (Counter)metrics.getOrCreate((MetricConfig)new Counter.Config("app", COUNTER_DEPRECATED_TXNS_NAME).withDescription(COUNTER_RECEIVED_DEPRECATED_DESC));
        this.superDeprecatedCounter = (Counter)metrics.getOrCreate((MetricConfig)new Counter.Config("app", COUNTER_SUPER_DEPRECATED_TXNS_NAME).withDescription(COUNTER_RECEIVED_SUPER_DEPRECATED_DESC));
        this.nonGovernanceOversizedTransactionsCounter = (Counter)metrics.getOrCreate((MetricConfig)new Counter.Config("app", COUNTER_NON_GOVERNANCE_OVERSIZED_TXNS).withDescription(NON_GOVERNANCE_OVERSIZED_TXNS_DESC));
    }

    @NonNull
    public TransactionInfo parseAndCheck(@NonNull Bytes buffer) throws PreCheckException {
        if (buffer.length() > (long)this.maxIngestParseSize()) {
            throw new PreCheckException(ResponseCodeEnum.TRANSACTION_OVERSIZE);
        }
        Transaction tx = this.parse(buffer);
        return this.check(tx);
    }

    @NonNull
    public TransactionInfo parseSignedAndCheck(@NonNull Bytes buffer, int maxBytes) throws PreCheckException {
        if (buffer.length() > (long)maxBytes) {
            throw new PreCheckException(ResponseCodeEnum.TRANSACTION_OVERSIZE);
        }
        SignedTransaction signedTx = this.parseSigned(buffer);
        return this.checkSigned(signedTx, buffer);
    }

    @NonNull
    public TransactionInfo parseSignedAndCheck(@NonNull Bytes buffer) throws PreCheckException {
        return this.parseSignedAndCheck(buffer, this.maxIngestParseSize());
    }

    @NonNull
    public Transaction parse(@NonNull Bytes buffer) throws PreCheckException {
        return (Transaction)this.parseStrict(buffer.toReadableSequentialData(), Transaction.PROTOBUF, ResponseCodeEnum.INVALID_TRANSACTION);
    }

    @NonNull
    public SignedTransaction parseSigned(@NonNull Bytes buffer) throws PreCheckException {
        return (SignedTransaction)this.parseStrict(buffer.toReadableSequentialData(), SignedTransaction.PROTOBUF, ResponseCodeEnum.INVALID_TRANSACTION);
    }

    @NonNull
    public TransactionInfo check(@NonNull Transaction tx) throws PreCheckException {
        SignedTransaction signedTx;
        Bytes serializedSignedTx;
        this.checkTransactionDeprecation(tx);
        if (tx.signedTransactionBytes().length() > 0L) {
            serializedSignedTx = tx.signedTransactionBytes();
            signedTx = (SignedTransaction)this.parseStrict(serializedSignedTx.toReadableSequentialData(), SignedTransaction.PROTOBUF, ResponseCodeEnum.INVALID_TRANSACTION);
            PreCheckException.validateFalsePreCheck((boolean)signedTx.useSerializedTxMessageHashAlgorithm(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_SERIALIZED_TX_MESSAGE_HASH_ALGORITHM);
        } else {
            signedTx = new SignedTransaction(tx.bodyBytes(), tx.sigMap(), true);
            serializedSignedTx = SignedTransaction.PROTOBUF.toBytes((Object)signedTx);
        }
        if (!signedTx.hasSigMap()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        }
        return this.check(signedTx, serializedSignedTx);
    }

    @NonNull
    public TransactionInfo checkSigned(@NonNull SignedTransaction signedTx, @NonNull Bytes serializedSignedTx) throws PreCheckException {
        Objects.requireNonNull(signedTx);
        Objects.requireNonNull(serializedSignedTx);
        return this.check(signedTx, serializedSignedTx);
    }

    public TransactionInfo checkParsed(@NonNull TransactionInfo txInfo) throws PreCheckException {
        try {
            this.checkPrefixMismatch(txInfo.signatureMap().sigPair());
            this.checkTransactionBody(txInfo.txBody(), txInfo.functionality());
            return txInfo;
        }
        catch (PreCheckException e) {
            throw new DueDiligenceException(e.responseCode(), txInfo);
        }
    }

    private void checkTransactionDeprecation(@NonNull Transaction tx) throws PreCheckException {
        boolean hasDeprecatedBodyBytes;
        if (tx.hasBody() || tx.hasSigs()) {
            this.superDeprecatedCounter.increment();
        }
        boolean hasSignedTxnBytes = tx.signedTransactionBytes().length() > 0L;
        boolean hasDeprecatedSigMap = tx.sigMap() != null;
        boolean bl = hasDeprecatedBodyBytes = tx.bodyBytes().length() > 0L;
        if (hasDeprecatedSigMap || hasDeprecatedBodyBytes) {
            this.deprecatedCounter.increment();
        }
        if (hasSignedTxnBytes) {
            if (hasDeprecatedBodyBytes || hasDeprecatedSigMap) {
                throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION);
            }
        } else if (!hasDeprecatedBodyBytes) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        }
    }

    private void checkTransactionBody(@NonNull TransactionBody txBody, HederaFunctionality functionality) throws PreCheckException {
        this.checkTransactionID(txBody.transactionIDOrThrow());
        PreCheckValidator.checkMemo((String)txBody.memo(), (int)this.hederaConfig().transactionMaxMemoUtf8Bytes());
        PreCheckValidator.checkMaxCustomFees((List)txBody.maxCustomFees(), (HederaFunctionality)functionality);
        if (txBody.transactionFee() < 0L) {
            throw new PreCheckException(ResponseCodeEnum.INSUFFICIENT_TX_FEE);
        }
        if (!txBody.hasTransactionValidDuration()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION_DURATION);
        }
    }

    public void checkTransactionSize(@NonNull TransactionInfo txInfo) throws PreCheckException {
        HederaFunctionality functionality;
        int maxSizeAllowed;
        int txSize = txInfo.signedTx().protobufSize();
        if (txSize > (maxSizeAllowed = this.getMaxAllowedTransactionSize(functionality = txInfo.functionality(), null)) && !this.isExemptFromStandardSizeLimit(functionality)) {
            throw new PreCheckException(ResponseCodeEnum.TRANSACTION_OVERSIZE);
        }
    }

    public void checkTransactionSizeLimitBasedOnPayer(@NonNull TransactionInfo txInfo, @NonNull AccountID payerAccountId) throws PreCheckException {
        HederaFunctionality functionality;
        int maxSizeAllowed;
        if (!this.governanceTransactionsConfig().isEnabled()) {
            return;
        }
        int txSize = txInfo.signedTx().protobufSize();
        if (txSize > (maxSizeAllowed = this.getMaxAllowedTransactionSize(functionality = txInfo.functionality(), payerAccountId)) && !this.isExemptFromStandardSizeLimit(functionality)) {
            boolean isGovernancePayer = this.isGovernanceAccount(payerAccountId);
            if (!isGovernancePayer) {
                this.nonGovernanceOversizedTransactionsCounter.increment();
            }
            throw new PreCheckException(ResponseCodeEnum.TRANSACTION_OVERSIZE);
        }
    }

    private int getMaxAllowedTransactionSize(@NonNull HederaFunctionality functionality, @Nullable AccountID payerAccountId) {
        Set allowedJumboFunctionalities;
        boolean isJumboEnabled = this.jumboTransactionsConfig().isEnabled();
        boolean isGovernanceEnabled = this.governanceTransactionsConfig().isEnabled();
        if (isGovernanceEnabled && payerAccountId == null) {
            return this.governanceTransactionsConfig().maxTxnSize();
        }
        if (isGovernanceEnabled && this.isGovernanceAccount(payerAccountId)) {
            return this.governanceTransactionsConfig().maxTxnSize();
        }
        if (isJumboEnabled && (allowedJumboFunctionalities = this.jumboTransactionsConfig().allowedHederaFunctionalities()).contains(CommonPbjConverters.fromPbj((HederaFunctionality)functionality))) {
            return this.jumboTransactionsConfig().maxTxnSize();
        }
        return this.hederaConfig().transactionMaxBytes();
    }

    private boolean isExemptFromStandardSizeLimit(@NonNull HederaFunctionality functionality) {
        return NON_JUMBO_TRANSACTIONS_BIGGER_THAN_6_KB.contains(functionality);
    }

    private boolean isGovernanceAccount(@NonNull AccountID accountId) {
        return this.governanceTransactionsConfig().accountsRange().contains(accountId.accountNumOrThrow().longValue());
    }

    public void checkTimeBox(@NonNull TransactionBody txBody, @NonNull Instant consensusTime, @NonNull RequireMinValidLifetimeBuffer requireMinValidLifetimeBuffer) throws PreCheckException {
        long validDuration;
        Objects.requireNonNull(txBody, "txBody must not be null");
        Timestamp start = txBody.transactionIDOrThrow().transactionValidStartOrThrow();
        Duration duration = txBody.transactionValidDurationOrThrow();
        long min = this.hederaConfig().transactionMinValidDuration();
        long max = this.hederaConfig().transactionMaxValidDuration();
        int minValidityBufferSecs = requireMinValidLifetimeBuffer == RequireMinValidLifetimeBuffer.YES ? this.hederaConfig().transactionMinValidityBufferSecs() : 0;
        long validForSecs = duration.seconds();
        if (validForSecs < min || validForSecs > max) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION_DURATION);
        }
        Instant validStart = this.toInstant(start);
        if (validStart.plusSeconds(validDuration = this.toSecondsDuration(validForSecs, validStart, minValidityBufferSecs)).isBefore(consensusTime)) {
            throw new PreCheckException(ResponseCodeEnum.TRANSACTION_EXPIRED);
        }
        if (validStart.isAfter(consensusTime)) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION_START);
        }
    }

    private void checkTransactionID(@NonNull TransactionID txnId) throws PreCheckException {
        boolean isPlausibleAccount;
        AccountID accountID = txnId.accountID();
        boolean bl = isPlausibleAccount = accountID != null && accountID.shardNum() == this.hederaConfig().shard() && accountID.realmNum() == this.hederaConfig().realm() && accountID.hasAccountNum() && accountID.accountNumOrElse(Long.valueOf(0L)) > 0L;
        if (!isPlausibleAccount) {
            throw new PreCheckException(ResponseCodeEnum.PAYER_ACCOUNT_NOT_FOUND);
        }
        if (txnId.scheduled() || txnId.nonce() != 0) {
            throw new PreCheckException(ResponseCodeEnum.TRANSACTION_ID_FIELD_NOT_ALLOWED);
        }
        if (!txnId.hasTransactionValidStart()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION_START);
        }
    }

    @NonNull
    private Instant toInstant(Timestamp timestamp) {
        return Instant.ofEpochSecond(Math.clamp(timestamp.seconds(), Instant.MIN.getEpochSecond(), Instant.MAX.getEpochSecond()), Math.clamp((long)timestamp.nanos(), Instant.MIN.getNano(), Instant.MAX.getNano()));
    }

    private long toSecondsDuration(long validForSecs, Instant validStart, long minValidBufferSecs) {
        return Math.min(validForSecs - minValidBufferSecs, Instant.MAX.getEpochSecond() - validStart.getEpochSecond());
    }

    @NonNull
    private <T> T parseStrict(@NonNull ReadableSequentialData data, Codec<T> codec, ResponseCodeEnum parseErrorCode) throws PreCheckException {
        try {
            return (T)codec.parseStrict(data);
        }
        catch (ParseException e) {
            if (e.getCause() instanceof UnknownFieldException) {
                throw new PreCheckException(ResponseCodeEnum.TRANSACTION_HAS_UNKNOWN_FIELDS);
            }
            logger.warn("ParseException while parsing protobuf", (Throwable)e);
            throw new PreCheckException(parseErrorCode);
        }
    }

    private TransactionInfo check(@NonNull SignedTransaction signedTx, @NonNull Bytes serializedSignedTx) throws PreCheckException {
        HederaFunctionality functionality;
        PreCheckException.validateTruePreCheck((boolean)signedTx.hasSigMap(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        SignatureMap signatureMap = signedTx.sigMapOrThrow();
        TransactionBody txBody = (TransactionBody)this.parseStrict(signedTx.bodyBytes().toReadableSequentialData(), TransactionBody.PROTOBUF, ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        try {
            functionality = HapiUtils.functionOf((TransactionBody)txBody);
        }
        catch (UnknownHederaFunctionality e) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        }
        if (!txBody.hasTransactionID()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION_ID);
        }
        TransactionID txnId = txBody.transactionIDOrThrow();
        if (!txnId.hasAccountID()) {
            throw new PreCheckException(ResponseCodeEnum.PAYER_ACCOUNT_NOT_FOUND);
        }
        return this.checkParsed(new TransactionInfo(signedTx, txBody, signatureMap, signedTx.bodyBytes(), functionality, serializedSignedTx));
    }

    private void checkPrefixMismatch(@NonNull List<SignaturePair> sigPairs) throws PreCheckException {
        List<SignaturePair> sortedList = this.sort(sigPairs);
        if (sortedList.size() > 1) {
            SignaturePair prev = sortedList.getFirst();
            int size = sortedList.size();
            for (int i = 1; i < size; ++i) {
                SignaturePair curr = sortedList.get(i);
                Bytes p1 = prev.pubKeyPrefix();
                Bytes p2 = curr.pubKeyPrefix();
                if (p1.length() == 0L && p2.length() == 0L || p2.matchesPrefix((RandomAccessData)p1)) {
                    throw new PreCheckException(ResponseCodeEnum.KEY_PREFIX_MISMATCH);
                }
                prev = curr;
            }
        }
    }

    @NonNull
    private List<SignaturePair> sort(@NonNull List<SignaturePair> sigPairs) {
        ArrayList<SignaturePair> sortedList = new ArrayList<SignaturePair>(sigPairs);
        sortedList.sort((s1, s2) -> {
            Bytes p1 = s1.pubKeyPrefix();
            Bytes p2 = s2.pubKeyPrefix();
            if (p1.length() != p2.length()) {
                return (int)(p1.length() - p2.length());
            }
            int i = 0;
            while ((long)i < p1.length()) {
                byte b2;
                byte b1 = p1.getByte((long)i);
                if (b1 != (b2 = p2.getByte((long)i))) {
                    return b1 - b2;
                }
                ++i;
            }
            return 0;
        });
        return sortedList;
    }

    private HederaConfig hederaConfig() {
        return (HederaConfig)this.configProvider.getConfiguration().getConfigData(HederaConfig.class);
    }

    private JumboTransactionsConfig jumboTransactionsConfig() {
        return (JumboTransactionsConfig)this.configProvider.getConfiguration().getConfigData(JumboTransactionsConfig.class);
    }

    private GovernanceTransactionsConfig governanceTransactionsConfig() {
        return (GovernanceTransactionsConfig)this.configProvider.getConfiguration().getConfigData(GovernanceTransactionsConfig.class);
    }

    private int maxIngestParseSize() {
        boolean jumboTxnEnabled = this.jumboTransactionsConfig().isEnabled();
        int jumboMaxTxnSize = this.jumboTransactionsConfig().maxTxnSize();
        int transactionMaxBytes = this.hederaConfig().transactionMaxBytes();
        boolean governanceTxnEnabled = this.governanceTransactionsConfig().isEnabled();
        int governanceTxnSize = this.governanceTransactionsConfig().maxTxnSize();
        return governanceTxnEnabled ? governanceTxnSize : (jumboTxnEnabled ? jumboMaxTxnSize : transactionMaxBytes);
    }

    public static enum RequireMinValidLifetimeBuffer {
        YES,
        NO;

    }
}

