/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.TokenService;
import com.hedera.node.app.service.token.impl.calculator.CryptoApproveAllowanceFeeCalculator;
import com.hedera.node.app.service.token.impl.calculator.CryptoCreateFeeCalculator;
import com.hedera.node.app.service.token.impl.calculator.CryptoDeleteAllowanceFeeCalculator;
import com.hedera.node.app.service.token.impl.calculator.CryptoDeleteFeeCalculator;
import com.hedera.node.app.service.token.impl.calculator.CryptoTransferFeeCalculator;
import com.hedera.node.app.service.token.impl.calculator.CryptoUpdateFeeCalculator;
import com.hedera.node.app.service.token.impl.calculator.TokenBurnFeeCalculator;
import com.hedera.node.app.service.token.impl.calculator.TokenCreateFeeCalculator;
import com.hedera.node.app.service.token.impl.calculator.TokenDeleteFeeCalculator;
import com.hedera.node.app.service.token.impl.calculator.TokenFreezeAccountFeeCalculator;
import com.hedera.node.app.service.token.impl.calculator.TokenMintFeeCalculator;
import com.hedera.node.app.service.token.impl.calculator.TokenPauseFeeCalculator;
import com.hedera.node.app.service.token.impl.calculator.TokenUnfreezeAccountFeeCalculator;
import com.hedera.node.app.service.token.impl.calculator.TokenUnpauseFeeCalculator;
import com.hedera.node.app.service.token.impl.schemas.V0490TokenSchema;
import com.hedera.node.app.service.token.impl.schemas.V0530TokenSchema;
import com.hedera.node.app.service.token.impl.schemas.V0610TokenSchema;
import com.hedera.node.app.spi.AppContext;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.SchemaRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Set;

public class TokenServiceImpl
implements TokenService {
    public static final long THREE_MONTHS_IN_SECONDS = 7776000L;
    public static final long MAX_SERIAL_NO_ALLOWED = 0xFFFFFFFFL;
    public static final long HBARS_TO_TINYBARS = 100000000L;
    public static final ZoneId ZONE_UTC = ZoneId.of("UTC");
    private final EntityIdFactory idFactory;

    public TokenServiceImpl(@NonNull AppContext appContext) {
        Objects.requireNonNull(appContext);
        this.idFactory = appContext.idFactory();
    }

    public void registerSchemas(@NonNull SchemaRegistry registry) {
        Objects.requireNonNull(registry);
        registry.register((Schema)new V0490TokenSchema());
        registry.register((Schema)new V0530TokenSchema());
        registry.register((Schema)new V0610TokenSchema());
    }

    public Set<ServiceFeeCalculator> serviceFeeCalculators() {
        return Set.of(new CryptoApproveAllowanceFeeCalculator(), new CryptoCreateFeeCalculator(), new CryptoDeleteAllowanceFeeCalculator(), new CryptoDeleteFeeCalculator(), new CryptoUpdateFeeCalculator(), new CryptoTransferFeeCalculator(), new TokenCreateFeeCalculator(), new TokenMintFeeCalculator(), new TokenPauseFeeCalculator(), new TokenUnpauseFeeCalculator(), new TokenFreezeAccountFeeCalculator(), new TokenUnfreezeAccountFeeCalculator(), new TokenBurnFeeCalculator(), new TokenDeleteFeeCalculator());
    }
}

