/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.media.type;

import io.helidon.common.media.type.Detectors;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypeEnum;
import io.helidon.common.media.type.MediaTypeImpl;
import io.helidon.common.media.type.ParserMode;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;

public final class MediaTypes {
    public static final MediaType WILDCARD = MediaTypeEnum.WILDCARD;
    public static final MediaType APPLICATION_XML = MediaTypeEnum.APPLICATION_XML;
    public static final MediaType APPLICATION_ATOM_XML = MediaTypeEnum.APPLICATION_ATOM_XML;
    public static final MediaType APPLICATION_XHTML_XML = MediaTypeEnum.APPLICATION_XHTML_XML;
    public static final MediaType APPLICATION_SVG_XML = MediaTypeEnum.APPLICATION_SVG_XML;
    public static final MediaType APPLICATION_JSON = MediaTypeEnum.APPLICATION_JSON;
    public static final MediaType APPLICATION_JSON_PATCH_JSON = MediaTypeEnum.APPLICATION_JSON_PATCH_JSON;
    public static final MediaType APPLICATION_STREAM_JSON = MediaTypeEnum.APPLICATION_STREAM_JSON;
    public static final MediaType APPLICATION_FORM_URLENCODED = MediaTypeEnum.APPLICATION_FORM_URLENCODED;
    public static final MediaType MULTIPART_FORM_DATA = MediaTypeEnum.MULTIPART_FORM_DATA;
    public static final MediaType MULTIPART_BYTERANGES = MediaTypeEnum.MULTIPART_BYTERANGES;
    public static final MediaType APPLICATION_OCTET_STREAM = MediaTypeEnum.APPLICATION_OCTET_STREAM;
    public static final MediaType TEXT_PLAIN = MediaTypeEnum.TEXT_PLAIN;
    public static final MediaType TEXT_XML = MediaTypeEnum.TEXT_XML;
    public static final MediaType TEXT_HTML = MediaTypeEnum.TEXT_HTML;
    public static final MediaType APPLICATION_OPENAPI_YAML = MediaTypeEnum.APPLICATION_OPENAPI_YAML;
    public static final MediaType APPLICATION_OPENAPI_JSON = MediaTypeEnum.APPLICATION_OPENAPI_JSON;
    public static final MediaType APPLICATION_OPENMETRICS_TEXT = MediaTypeEnum.APPLICATION_OPENMETRICS_TEXT;
    public static final MediaType APPLICATION_X_YAML = MediaTypeEnum.APPLICATION_X_YAML;
    public static final MediaType APPLICATION_YAML = MediaTypeEnum.APPLICATION_YAML;
    public static final MediaType TEXT_X_YAML = MediaTypeEnum.TEXT_X_YAML;
    public static final MediaType TEXT_YAML = MediaTypeEnum.TEXT_YAML;
    public static final MediaType APPLICATION_JAVASCRIPT = MediaTypeEnum.APPLICATION_JAVASCRIPT;
    public static final MediaType TEXT_EVENT_STREAM = MediaTypeEnum.TEXT_EVENT_STREAM;
    public static final MediaType APPLICATION_X_NDJSON = MediaTypeEnum.APPLICATION_X_NDJSON;
    public static final MediaType APPLICATION_HOCON = MediaTypeEnum.APPLICATION_HOCON;
    public static final String WILDCARD_VALUE = "*/*";
    public static final String APPLICATION_XML_VALUE = "application/xml";
    public static final String APPLICATION_ATOM_XML_VALUE = "application/atom+xml";
    public static final String APPLICATION_XHTML_XML_VALUE = "application/xhtml+xml";
    public static final String APPLICATION_SVG_XML_VALUE = "application/svg+xml";
    public static final String APPLICATION_JSON_VALUE = "application/json";
    public static final String APPLICATION_JSON_PATCH_JSON_VALUE = "application/json-patch+json";
    public static final String APPLICATION_STREAM_JSON_VALUE = "application/stream+json";
    public static final String APPLICATION_FORM_URLENCODED_VALUE = "application/x-www-form-urlencoded";
    public static final String MULTIPART_FORM_DATA_VALUE = "multipart/form-data";
    public static final String MULTIPART_BYTERANGES_VALUE = "multipart/byteranges";
    public static final String APPLICATION_OCTET_STREAM_VALUE = "application/octet-stream";
    public static final String TEXT_PLAIN_VALUE = "text/plain";
    public static final String TEXT_XML_VALUE = "text/xml";
    public static final String TEXT_HTML_VALUE = "text/html";
    public static final String APPLICATION_OPENMETRICS_TEXT_VALUE = "application/openmetrics-text";
    public static final String APPLICATION_OPENAPI_YAML_VALUE = "application/vnd.oai.openapi";
    public static final String APPLICATION_OPENAPI_JSON_VALUE = "application/vnd.oai.openapi+json";
    public static final String APPLICATION_X_YAML_VALUE = "application/x-yaml";
    public static final String APPLICATION_YAML_VALUE = "application/yaml";
    public static final String TEXT_X_YAML_VALUE = "text/x-yaml";
    public static final String TEXT_YAML_VALUE = "text/yaml";
    public static final String APPLICATION_JAVASCRIPT_VALUE = "application/javascript";
    public static final String TEXT_EVENT_STREAM_VALUE = "text/event-stream";
    public static final String APPLICATION_X_NDJSON_VALUE = "application/x-ndjson";
    public static final String APPLICATION_HOCON_VALUE = "application/hocon";

    private MediaTypes() {
    }

    public static MediaType create(String type, String subtype) {
        MediaTypeEnum mediaTypeEnum = MediaTypeEnum.find(type + "/" + subtype);
        if (mediaTypeEnum == null) {
            return new MediaTypeImpl(type, subtype, type + "/" + subtype);
        }
        return mediaTypeEnum;
    }

    public static MediaType create(String fullType) {
        MediaTypeEnum types = MediaTypeEnum.find(fullType);
        return types == null ? MediaTypeImpl.parse(fullType, ParserMode.STRICT) : types;
    }

    public static MediaType create(String fullType, ParserMode parserMode) {
        MediaTypeEnum types = MediaTypeEnum.find(fullType);
        return types == null ? MediaTypeImpl.parse(fullType, parserMode) : types;
    }

    public static Optional<MediaType> detectType(URL url) {
        return Detectors.detectType(url);
    }

    public static Optional<MediaType> detectType(URI uri) {
        return Detectors.detectType(uri);
    }

    public static Optional<MediaType> detectType(Path file) {
        return Detectors.detectType(file);
    }

    public static Optional<MediaType> detectType(String fileName) {
        return Detectors.detectType(fileName);
    }

    public static Optional<MediaType> detectExtensionType(String fileSuffix) {
        return Detectors.detectExtensionType(fileSuffix);
    }
}

