/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import org.identityconnectors.common.StringUtil;

public class IOUtil {
    public static final String UTF8 = "UTF-8";

    private IOUtil() {
        throw new AssertionError();
    }

    public static void quietClose(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void quietClose(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void quietClose(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void quietClose(OutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getResourcePath(Class<?> c, String res) {
        String result;
        assert (c != null && StringUtil.isNotBlank(res));
        String classname = c.getName();
        int dot = classname.lastIndexOf(46);
        if (dot >= 0) {
            String pkg = classname.substring(0, dot);
            result = pkg.replace('.', '/') + '/' + res;
        } else {
            result = res;
        }
        return result;
    }

    public static InputStream getResourceAsStream(Class<?> clazz, String res) {
        assert (clazz != null && StringUtil.isNotBlank(res));
        InputStream ret = null;
        ClassLoader classLoader = clazz.getClassLoader();
        String[] name = new String[]{res, IOUtil.getResourcePath(clazz, res), "/" + IOUtil.getResourcePath(clazz, res)};
        for (int i = 0; ret == null && i < name.length; ++i) {
            ret = classLoader.getResourceAsStream(name[i]);
        }
        return ret;
    }

    public static byte[] getResourceAsBytes(Class<?> clazz, String res) {
        assert (clazz != null && StringUtil.isNotBlank(res));
        InputStream ins = IOUtil.getResourceAsStream(clazz, res);
        if (ins == null) {
            throw new IllegalStateException("Resource not found: " + res);
        }
        byte[] ret = IOUtil.inputStreamToBytes(ins);
        IOUtil.quietClose(ins);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceAsString(Class<?> clazz, String res, Charset charset) {
        assert (clazz != null && StringUtil.isNotBlank(res));
        String ret = null;
        InputStream ins = IOUtil.getResourceAsStream(clazz, res);
        if (ins != null) {
            try {
                InputStreamReader rdr = new InputStreamReader(ins, charset);
                ret = IOUtil.readerToString(rdr);
            }
            finally {
                IOUtil.quietClose(ins);
            }
        }
        return ret;
    }

    public static String getResourceAsString(Class<?> clazz, String res) {
        assert (clazz != null && StringUtil.isNotBlank(res));
        return IOUtil.getResourceAsString(clazz, res, Charset.forName(UTF8));
    }

    public static byte[] inputStreamToBytes(InputStream ins) {
        byte[] ret = null;
        try {
            int len = 0;
            byte[] buf = new byte[2048];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = ins.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            ret = out.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static String readerToString(Reader rdr) {
        String ret = null;
        try {
            int len = 0;
            char[] buf = new char[2048];
            StringWriter wrt = new StringWriter();
            while ((len = rdr.read(buf)) != -1) {
                wrt.write(buf, 0, len);
            }
            ret = wrt.toString();
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File src, File dest) throws IOException {
        boolean ret = true;
        if (src == null || dest == null || !src.isFile()) {
            throw new FileNotFoundException();
        }
        if (dest.isDirectory()) {
            String name = src.getName();
            dest = new File(dest, name);
        }
        FileInputStream fis = null;
        FileOutputStream fout = null;
        try {
            fis = new FileInputStream(src);
            fout = new FileOutputStream(dest);
            ret = IOUtil.copyFile(fis, fout) > 0L;
        }
        catch (Throwable throwable) {
            IOUtil.quietClose(fis);
            IOUtil.quietClose(fout);
            throw throwable;
        }
        IOUtil.quietClose(fis);
        IOUtil.quietClose(fout);
        return ret;
    }

    public static long copyFile(InputStream fis, OutputStream fos) throws IOException {
        long ret = 0L;
        byte[] bytes = new byte[8192];
        int rd = fis.read(bytes);
        while (rd != -1) {
            fos.write(bytes, 0, rd);
            ret += (long)rd;
            rd = fis.read(bytes);
        }
        return ret;
    }

    public static long checksum(String fileName) throws IOException, FileNotFoundException {
        return IOUtil.checksum(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long checksum(File file) throws IOException, FileNotFoundException {
        long l;
        FileInputStream fis = null;
        byte[] bytes = new byte[16384];
        try {
            fis = new FileInputStream(file);
            CRC32 chkSum = new CRC32();
            int len = fis.read(bytes);
            while (len != -1) {
                chkSum.update(bytes, 0, len);
                len = fis.read(bytes);
            }
            l = chkSum.getValue();
        }
        catch (Throwable throwable) {
            IOUtil.quietClose(fis);
            throw throwable;
        }
        IOUtil.quietClose(fis);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStreamBytes(InputStream is, boolean close) throws IOException {
        byte[] bytes = null;
        if (is != null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
            try {
                int bytesRead = 0;
                byte[] buf = new byte[1024];
                while ((bytesRead = is.read(buf)) != -1) {
                    bout.write(buf, 0, bytesRead);
                }
                bytes = bout.toByteArray();
            }
            finally {
                if (close) {
                    IOUtil.quietClose(is);
                }
            }
        }
        return bytes;
    }

    public static void delete(File f) throws IOException {
        if (f.exists()) {
            String msg = "Failed to delete: " + f;
            if (f.isDirectory()) {
                File[] fs = f.listFiles();
                for (int x = 0; x < fs.length; ++x) {
                    IOUtil.delete(fs[x]);
                }
                if (!f.delete()) {
                    throw new IOException(msg);
                }
            } else if (f.isFile() && !f.delete()) {
                throw new IOException(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesFile(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        try {
            Properties rv = new Properties();
            rv.load(in);
            Properties properties = rv;
            return properties;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storePropertiesFile(File f, Properties properties) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        try {
            properties.store(out, null);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getResourceAsProperties(ClassLoader loader, String path) throws IOException {
        InputStream in = loader.getResourceAsStream(path);
        if (in == null) {
            return null;
        }
        try {
            Properties rv = new Properties();
            rv.load(in);
            Properties properties = rv;
            return properties;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractResourceToFile(Class<?> clazz, String path, File file) throws IOException {
        InputStream in = IOUtil.getResourceAsStream(clazz, path);
        if (in == null) {
            throw new IOException("Missing resource: " + path);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            IOUtil.copyFile(in, out);
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unjar(JarFile jarFile, File toDir) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            File outFile = new File(toDir, entry.getName());
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(outFile);
                InputStream in = jarFile.getInputStream(entry);
                IOUtil.copyFile(in, fos);
            }
            finally {
                if (fos == null) continue;
                fos.close();
            }
        }
    }

    public static String readFileUTF8(File file) throws IOException {
        byte[] bytes = IOUtil.readFileBytes(file);
        return new String(bytes, UTF8);
    }

    public static byte[] readFileBytes(File file) throws IOException {
        FileInputStream ins = new FileInputStream(file);
        byte[] bytes = IOUtil.readInputStreamBytes(ins, true);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileUTF8(File file, String contents) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF8);
        try {
            w.write(contents);
        }
        finally {
            ((Writer)w).close();
        }
    }

    public static URL makeURL(File dir, String path) throws IOException {
        File file = new File(dir, path);
        if (!file.isFile()) {
            throw new IOException(file.getPath() + " does not exist");
        }
        return file.toURL();
    }

    public static Properties loadPropertiesFile(String string) throws IOException {
        return IOUtil.loadPropertiesFile(new File(string));
    }
}

