/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.concurrent.locks.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.hiero.base.concurrent.locks.AutoClosableResourceLock;
import org.hiero.base.concurrent.locks.internal.AcquiredResource;
import org.hiero.base.concurrent.locks.internal.NotAcquiredResource;
import org.hiero.base.concurrent.locks.locked.LockedResource;
import org.hiero.base.concurrent.locks.locked.MaybeLockedResource;

public final class ResourceLock<T>
implements AutoClosableResourceLock<T> {
    private final Lock lock;
    private final MaybeLockedResource<T> acquired;
    private final MaybeLockedResource<T> notAcquired;

    public ResourceLock(@NonNull Lock lock, @Nullable T resource) {
        this.lock = lock;
        this.acquired = new AcquiredResource<T>(lock::unlock, resource);
        this.notAcquired = new NotAcquiredResource();
    }

    @Override
    @NonNull
    public LockedResource<T> lock() {
        this.lock.lock();
        return this.acquired;
    }

    @Override
    @NonNull
    public LockedResource<T> lockInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
        return this.acquired;
    }

    @Override
    @NonNull
    public MaybeLockedResource<T> tryLock() {
        if (this.lock.tryLock()) {
            return this.acquired;
        }
        return this.notAcquired;
    }

    @Override
    @NonNull
    public MaybeLockedResource<T> tryLock(long time, @NonNull TimeUnit unit) throws InterruptedException {
        if (this.lock.tryLock(time, unit)) {
            return this.acquired;
        }
        return this.notAcquired;
    }

    @Override
    @NonNull
    public Condition newCondition() {
        return this.lock.newCondition();
    }
}

