/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.ethereum.rlp;

import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.Bytes48;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt64;
import org.hyperledger.besu.ethereum.rlp.RLPException;

public interface RLPInput {
    public boolean isDone();

    public boolean nextIsList();

    public boolean nextIsNull();

    public int nextSize();

    public int nextOffset();

    public boolean isEndOfCurrentList();

    public void skipNext();

    public int enterList();

    public void leaveList();

    public void leaveListLenient();

    public long readLongScalar();

    public int readIntScalar();

    public BigInteger readBigIntegerScalar();

    public UInt64 readUInt64Scalar();

    public UInt256 readUInt256Scalar();

    public byte readByte();

    public short readShort();

    public int readInt();

    public long readLong();

    default public int readUnsignedByte() {
        if (this.isZeroLengthString()) {
            this.readBytes();
            return 0;
        }
        return this.readByte() & 0xFF;
    }

    default public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    default public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readUnsignedIntScalar();

    public int readUnsignedByteScalar();

    public InetAddress readInetAddress();

    public Bytes readBytes();

    public Bytes32 readBytes32();

    public Bytes48 readBytes48();

    public <T> T readBytes(Function<Bytes, T> var1);

    public RLPInput readAsRlp();

    public Bytes raw();

    public boolean isZeroLengthString();

    public void reset();

    public Bytes currentListAsBytes();

    default public <T> List<T> readList(Function<RLPInput, T> valueReader) {
        int size = this.enterList();
        ArrayList<T> res = size == 0 ? List.of() : new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            try {
                res.add(valueReader.apply(this));
                continue;
            }
            catch (RLPException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RLPException(String.format("Error applying element decoding function on element %d of the list", i), e);
            }
        }
        this.leaveList();
        return res;
    }
}

