/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.rules;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Supplier;
import org.hiero.consensus.event.creator.impl.EventCreationStatus;
import org.hiero.consensus.event.creator.impl.rules.EventCreationRule;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.transaction.SignatureTransactionCheck;

public class PlatformStatusRule
implements EventCreationRule {
    private final Supplier<PlatformStatus> platformStatusSupplier;
    private final SignatureTransactionCheck signatureTransactionCheck;

    public PlatformStatusRule(@NonNull Supplier<PlatformStatus> platformStatusSupplier, @NonNull SignatureTransactionCheck signatureTransactionCheck) {
        this.platformStatusSupplier = Objects.requireNonNull(platformStatusSupplier);
        this.signatureTransactionCheck = Objects.requireNonNull(signatureTransactionCheck);
    }

    @Override
    public boolean isEventCreationPermitted() {
        PlatformStatus currentStatus = this.platformStatusSupplier.get();
        if (currentStatus == PlatformStatus.FREEZING) {
            return this.signatureTransactionCheck.hasBufferedSignatureTransactions();
        }
        return currentStatus == PlatformStatus.ACTIVE || currentStatus == PlatformStatus.CHECKING;
    }

    @Override
    public void eventWasCreated() {
    }

    @Override
    @NonNull
    public EventCreationStatus getEventCreationStatus() {
        return EventCreationStatus.PLATFORM_STATUS;
    }
}

