/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Exception;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2Frame;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameType;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2Setting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class Http2Settings
implements Http2Frame<Http2Flag.SettingsFlags> {
    private static final System.Logger LOGGER = System.getLogger(Http2Settings.class.getName());
    private final Map<Integer, SettingValue> values;

    Http2Settings(Map<Integer, SettingValue> values) {
        this.values = values;
    }

    public static Http2Settings create() {
        return new Http2Settings(Map.of());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Http2Settings create(BufferData frame) {
        int available = frame.available();
        if (available % 6 != 0) {
            throw new Http2Exception(Http2ErrorCode.FRAME_SIZE, "Each setting must be 6 bytes, but frame size is " + available);
        }
        int settingCount = available / 6;
        HashMap<Integer, SettingValue> values = new HashMap<Integer, SettingValue>();
        for (int i = 0; i < settingCount; ++i) {
            int identifier = frame.readInt16();
            Http2Setting<?> http2Setting = Http2Setting.BY_ID.get(identifier);
            if (http2Setting == null) continue;
            values.put(identifier, new SettingValue(http2Setting, http2Setting.read(frame)));
        }
        return new Http2Settings(values);
    }

    private static String toString(String setting, int code, Object value) {
        return String.format("[%s (0x%02x):%s]", setting, code, value);
    }

    @Override
    public Http2FrameData toFrameData(Http2Settings settings, int streamId, Http2Flag.SettingsFlags flags) {
        BufferData data = BufferData.create((int)(this.values.size() * 6));
        this.values.values().forEach(it -> {
            Object value = it.value();
            Http2Setting<?> setting = it.setting();
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, String.format(" - Http2Settings %s:  %s", it.setting().toString(), it.value().toString()));
            }
            setting.write(data, value);
        });
        Http2FrameHeader header = Http2FrameHeader.create(data.available(), this.frameTypes(), flags, streamId);
        return new Http2FrameData(header, data);
    }

    @Override
    public String name() {
        return Http2FrameType.SETTINGS.name();
    }

    @Override
    public Http2FrameType frameType() {
        return Http2FrameType.SETTINGS;
    }

    @Override
    public Http2FrameTypes<Http2Flag.SettingsFlags> frameTypes() {
        return Http2FrameTypes.SETTINGS;
    }

    public String toString() {
        ArrayList<String> settings = new ArrayList<String>();
        for (SettingValue value : this.values.values()) {
            settings.add(Http2Settings.toString(value.setting.toString(), value.setting.identifier(), value.value()));
        }
        return String.join((CharSequence)"\n", settings);
    }

    public <T> T value(Http2Setting<T> setting) {
        SettingValue settingValue = this.values.get(setting.identifier());
        if (settingValue == null) {
            return setting.defaultValue();
        }
        return (T)settingValue.value();
    }

    public <T> Optional<T> presentValue(Http2Setting<T> setting) {
        return Optional.ofNullable(this.values.get(setting.identifier())).map(SettingValue::value).map(it -> it);
    }

    public boolean hasValue(Http2Setting<?> setting) {
        return this.values.containsKey(setting.identifier());
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, Http2Settings> {
        private final Map<Integer, SettingValue> settings = new HashMap<Integer, SettingValue>();

        private Builder() {
        }

        public Http2Settings build() {
            return new Http2Settings(Map.copyOf(this.settings));
        }

        public <T> Builder add(Http2Setting<T> settingType, T settingValue) {
            this.settings.put(settingType.identifier(), new SettingValue(settingType, settingValue));
            return this;
        }
    }

    private record SettingValue(Http2Setting<?> setting, Object value) {
        @Override
        public String toString() {
            return String.valueOf(this.setting) + ": " + String.valueOf(this.value);
        }
    }
}

